package org.mule.weave.v2.runtime.core.functions.runtime

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.AnyType
import org.mule.weave.v2.model.types.Type
import org.mule.weave.v2.model.values.Value

object LocationFunctionValue extends UnaryFunctionValue {

  override val R: Type = AnyType

  override def doExecute(value1: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val weaveLocation = value1.location()
    LocationBuilder.buildLocation(weaveLocation)
  }
}
