package org.mule.weave.v2.interpreted.node

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.node.executors.UnaryOpExecutor
import org.mule.weave.v2.model.values.Value

class UnaryOpNode(unaryOpExecutor: UnaryOpExecutor, right: ValueNode[_]) extends ValueNode[Any] with Product2[UnaryOpExecutor, ValueNode[_]] {

  override protected def doExecute(implicit ctx: ExecutionContext): Value[Any] = {
    val rightValue = right.execute
    unaryOpExecutor.executeUnary(rightValue)
  }

  def operationName: String = unaryOpExecutor.name

  override def _1: UnaryOpExecutor = unaryOpExecutor

  override def _2: ValueNode[_] = right

}
