package org.mule.weave.v2.runtime.core.functions.mime

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.values.ObjectValue
import org.mule.weave.v2.model.values.ObjectValueBuilder
import org.mule.weave.v2.model.values.StringValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.module.MimeType
import org.mule.weave.v2.runtime.utils.ResultTypeBuilder

object FromMimeTypeStringFunctionValue extends UnaryFunctionValue {

  private val ERROR_MESSAGE_KEY = "message"

  override val R: StringType.type = StringType

  override protected def doExecute(v: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val builder = ResultTypeBuilder()
    try {
      val mimeType = MimeType.fromSimpleString(v.evaluate.toString)
      val result = MimeTypeConverter.toObjectValue(mimeType)
      builder.withResult(result)
    } catch {
      case e: Exception =>
        builder.withError(createErrorResult(e))
    }
    builder.build()
  }

  private def createErrorResult(e: Exception): ObjectValue = {
    val builder = new ObjectValueBuilder()
    builder.addPair(ERROR_MESSAGE_KEY, StringValue(extractErrorMessage(e)))
    builder.build
  }

  private def extractErrorMessage(e: Exception): String = {
    s"${Option(e.getMessage).getOrElse("")}"
  }
}
