package org.mule.weave.v2.runtime.core.functions.mime

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.ObjectType
import org.mule.weave.v2.model.values.BooleanValue
import org.mule.weave.v2.model.values.Value

object IsHandledByFunctionValue extends BinaryFunctionValue {

  override val L = ObjectType
  override val R = ObjectType

  override protected def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val baseMimeTypeObjectSeq = leftValue.evaluate.materialize()
    val baseMimeType = MimeTypeConverter.toMimeType(baseMimeTypeObjectSeq)

    val otherMimeTypeObjectSeq = rightValue.evaluate.materialize()
    val otherMimeType = MimeTypeConverter.toMimeType(otherMimeTypeObjectSeq)

    val includes = baseMimeType.includes(otherMimeType)

    if (includes) {
      BooleanValue.TRUE_BOOL
    } else {
      BooleanValue.FALSE_BOOL
    }
  }
}
