package org.mule.weave.v2.runtime.core.functions.stringops

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.values.StringValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.location.UnknownLocation
import org.mule.weave.v2.parser.location.WeaveLocation

object StringPluralizeOperator extends UnaryFunctionValue {
  override val R = StringType

  override def doExecute(v: R.V)(implicit executionContext: EvaluationContext): Value[_] = {
    val str = v.evaluate.toString

    if (str.isEmpty)
      StringValue.empty
    else
      StringValue(Inflector.pluralize(str), this)
  }
}

