package org.mule.weave.v2.runtime.core.functions.stringops

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.BufferedCharSequence
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.values.CharSequenceValue
import org.mule.weave.v2.model.values.StringValue
import org.mule.weave.v2.model.values.Value

object StringTrimFunctionValue extends UnaryFunctionValue {
  override val R = StringType

  override def doExecute(v: R.V)(implicit executionContext: EvaluationContext): Value[_] = {
    val charSequence = v.evaluate
    charSequence match {
      case bufferedCharSequence: BufferedCharSequence => {
        CharSequenceValue(bufferedCharSequence.trim, this)
      }
      case _ => {
        StringValue(charSequence.toString.trim, this)
      }
    }
  }
}

object TrimFunctionValue {
  val value = Seq(StringTrimFunctionValue)
}
