package org.mule.weave.v2.interpreted.node

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.model.types.BooleanType
import org.mule.weave.v2.model.values.BooleanValue
import org.mule.weave.v2.model.values.Value

class OrNode(lhs: ValueNode[_], rhs: ValueNode[_]) extends ValueNode[Boolean] {
  override def doExecute(implicit ctx: ExecutionContext): Value[Boolean] = {
    BooleanValue(BooleanType.coerce(lhs.execute, lhs).evaluate || BooleanType.coerce(rhs.execute, rhs).evaluate, this)
  }
}

object OrNode {
  def apply(lhs: ValueNode[_], rhs: ValueNode[_]) = new OrNode(lhs, rhs)
}
