/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.runtime;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Properties;
import org.mule.weave.v2.api.tooling.annotation.DWAnnotationProcessor;
import org.mule.weave.v2.interpreted.debugger.server.DefaultWeaveDebuggingSession;
import org.mule.weave.v2.interpreted.debugger.server.WeaveDebuggerExecutor;
import org.mule.weave.v2.interpreted.debugger.server.tcp.TcpServerProtocol$;
import org.mule.weave.v2.model.service.LoggingService;
import org.mule.weave.v2.parser.DocumentParser;
import org.mule.weave.v2.parser.DocumentParser$;
import org.mule.weave.v2.parser.MappingParser$;
import org.mule.weave.v2.parser.Message;
import org.mule.weave.v2.parser.Message$;
import org.mule.weave.v2.parser.ast.structure.DocumentNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier$;
import org.mule.weave.v2.parser.location.WeaveLocation;
import org.mule.weave.v2.parser.phase.ModuleParsingPhasesManager;
import org.mule.weave.v2.parser.phase.ParsingContext;
import org.mule.weave.v2.parser.phase.ParsingContext$;
import org.mule.weave.v2.parser.phase.PhaseResult;
import org.mule.weave.v2.parser.phase.WatchdogParsingListener;
import org.mule.weave.v2.parser.phase.listener.ParsingNotificationListener;
import org.mule.weave.v2.parser.phase.metrics.CompilationMetrics;
import org.mule.weave.v2.parser.phase.metrics.ParsingMetricsCollectorListener;
import org.mule.weave.v2.parser.phase.metrics.ParsingMetricsCollectorListener$;
import org.mule.weave.v2.runtime.CompilationConfig;
import org.mule.weave.v2.runtime.CompilationResult;
import org.mule.weave.v2.runtime.DataWeaveResult;
import org.mule.weave.v2.runtime.DataWeaveScript;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine$;
import org.mule.weave.v2.runtime.DynamicModuleComponentFactory$;
import org.mule.weave.v2.runtime.InputType;
import org.mule.weave.v2.runtime.ModuleComponents;
import org.mule.weave.v2.runtime.ModuleComponentsFactory;
import org.mule.weave.v2.runtime.ParserConfiguration;
import org.mule.weave.v2.runtime.ParserConfiguration$;
import org.mule.weave.v2.runtime.ScriptingBindings;
import org.mule.weave.v2.runtime.ValidationConfiguration;
import org.mule.weave.v2.runtime.ValidationMessage;
import org.mule.weave.v2.runtime.ValidationPhase$;
import org.mule.weave.v2.runtime.ValidationResult;
import org.mule.weave.v2.runtime.WeaveCompiler$;
import org.mule.weave.v2.runtime.WeaveFile;
import org.mule.weave.v2.sdk.DefaultWeaveResource;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResourceFactory$;
import org.mule.weave.v2.ts.WeaveType;
import org.mule.weave.v2.utils.DataWeaveVersion;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0011ua\u0001B'O\u0001eC\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\tK\u0002\u0011\t\u0011)A\u0005M\"A\u0011\u000e\u0001BC\u0002\u0013\u0005!\u000e\u0003\u0005t\u0001\t\u0005\t\u0015!\u0003l\u0011\u0015!\b\u0001\"\u0001v\u0011\u001dQ\b\u00011A\u0005\nmD\u0001b \u0001A\u0002\u0013%\u0011\u0011\u0001\u0005\b\u0003\u001b\u0001\u0001\u0015)\u0003}\u0011!\ty\u0001\u0001a\u0001\n\u0013Y\b\"CA\t\u0001\u0001\u0007I\u0011BA\n\u0011\u001d\t9\u0002\u0001Q!\nqD1\"!\u0007\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u001c!Y\u0011\u0011\u0007\u0001A\u0002\u0003\u0007I\u0011BA\u001a\u0011-\t9\u0004\u0001a\u0001\u0002\u0003\u0006K!!\b\t\u0013\u0005e\u0002\u00011A\u0005\n\u0005m\u0002\"CA\"\u0001\u0001\u0007I\u0011BA#\u0011!\tI\u0005\u0001Q!\n\u0005u\u0002\u0002CA&\u0001\u0001\u0007I\u0011B>\t\u0013\u00055\u0003\u00011A\u0005\n\u0005=\u0003bBA*\u0001\u0001\u0006K\u0001 \u0005\f\u0003+\u0002\u0001\u0019!a\u0001\n\u0013\t9\u0006C\u0006\u0002f\u0001\u0001\r\u00111A\u0005\n\u0005\u001d\u0004bCA6\u0001\u0001\u0007\t\u0011)Q\u0005\u00033B\u0011\"!\u001c\u0001\u0001\u0004%I!a\u001c\t\u0013\u0005\u001d\u0005\u00011A\u0005\n\u0005%\u0005\u0002CAG\u0001\u0001\u0006K!!\u001d\t\u0017\u0005=\u0005\u00011AA\u0002\u0013%\u0011\u0011\u0013\u0005\f\u0003O\u0003\u0001\u0019!a\u0001\n\u0013\tI\u000bC\u0006\u0002.\u0002\u0001\r\u0011!Q!\n\u0005M\u0005B\u0002;\u0001\t\u0003\ty\u000b\u0003\u0004u\u0001\u0011\u0005\u0011\u0011\u0017\u0005\u0007i\u0002!\t!a.\t\u000f\u0005m\u0006\u0001\"\u0001\u0002>\"9\u00111\u0019\u0001\u0005\n\u0005\u0015\u0007bBAd\u0001\u0011\u0005\u0011Q\u0019\u0005\b\u0003\u0013\u0004A\u0011AAf\u0011\u001d\ti\r\u0001C\u0001\u0003\u001fDq!a;\u0001\t\u0003\ti\u000fC\u0004\u0002r\u0002!\t!a=\t\u000f\u0005U\b\u0001\"\u0001\u0002x\"9\u0011\u0011 \u0001\u0005\u0002\u0005=\u0006bBA~\u0001\u0011\u0005\u0011Q \u0005\b\u0005\u0003\u0001A\u0011\u0001B\u0002\u0011\u001d\u0011)\u0001\u0001C\u0001\u0003_CqAa\u0002\u0001\t\u0003\ty\u000bC\u0004\u0003\n\u0001!\t!a,\t\u000f\t-\u0001\u0001\"\u0001\u00020\"9!Q\u0002\u0001\u0005\n\t=\u0001b\u0002BI\u0001\u0011%!1\u0013\u0005\n\u0005[\u0003\u0011\u0013!C\u0005\u0005_C\u0011B!2\u0001#\u0003%IAa2\t\u000f\t-\u0007\u0001\"\u0001\u0003N\"9!Q\u001b\u0001\u0005\u0002\t]\u0007b\u0002Bv\u0001\u0011\u0005!Q\u001e\u0005\b\u0005k\u0004A\u0011\u0001B|\u0011\u001d\u0011i\u0001\u0001C\u0001\u0005wDqA!\u0004\u0001\t\u0003\u0019\t\u0001C\u0004\u0003\u000e\u0001!\taa\u0002\t\u000f\t5\u0001\u0001\"\u0001\u0004\u0010!9!Q\u0002\u0001\u0005\u0002\rM\u0001b\u0002B\u0007\u0001\u0011\u000511\u0004\u0005\b\u0005\u001b\u0001A\u0011AB\u0013\u0011\u001d\u0011i\u0001\u0001C\u0001\u0007cAqA!\u0004\u0001\t\u0003\u0019I\u0004C\u0004\u0003\u000e\u0001!\ta!\u0014\t\u000f\t5\u0001\u0001\"\u0001\u0004T!9!Q\u0002\u0001\u0005\u0002\re\u0003b\u0002B\u0007\u0001\u0011\u000511\r\u0005\b\u0005\u001b\u0001A\u0011AB4\u000f\u001d\u0019)P\u0014E\u0001\u0007o4a!\u0014(\t\u0002\re\bB\u0002;H\t\u0003\u0019Y\u0010C\u0004\u0004\u001e\u001e#\ta!@\t\u000f\ruu\t\"\u0001\u0005\u0004!91QT$\u0005\u0002\u0005=\u0006b\u0002C\u0004\u000f\u0012\u0005A\u0011\u0002\u0002\u0019\t\u0006$\u0018mV3bm\u0016\u001c6M]5qi&tw-\u00128hS:,'BA(Q\u0003\u001d\u0011XO\u001c;j[\u0016T!!\u0015*\u0002\u0005Y\u0014$BA*U\u0003\u00159X-\u0019<f\u0015\t)f+\u0001\u0003nk2,'\"A,\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001Q\u0006CA._\u001b\u0005a&\"A/\u0002\u000bM\u001c\u0017\r\\1\n\u0005}c&AB!osJ+g-A\td_6\u0004xN\\3oiN4\u0015m\u0019;pef\u0004\"AY2\u000e\u00039K!\u0001\u001a(\u0003/5{G-\u001e7f\u0007>l\u0007o\u001c8f]R\u001ch)Y2u_JL\u0018\u0001\u00069beNLgnZ\"p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002cO&\u0011\u0001N\u0014\u0002\u0014!\u0006\u00148/\u001a:D_:4\u0017nZ;sCRLwN\\\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0016\u0003-\u0004\"\u0001\\9\u000e\u00035T!A\\8\u0002\tU$\u0018\u000e\u001c\u0006\u0002a\u0006!!.\u0019<b\u0013\t\u0011XN\u0001\u0006Qe>\u0004XM\u001d;jKN\fabY8oM&<WO]1uS>t\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005m^D\u0018\u0010\u0005\u0002c\u0001!)\u0001-\u0002a\u0001C\")Q-\u0002a\u0001M\")\u0011.\u0002a\u0001W\u0006q\u0001O]8gS2,\u0007+\u0019:tS:<W#\u0001?\u0011\u0005mk\u0018B\u0001@]\u0005\u001d\u0011un\u001c7fC:\f!\u0003\u001d:pM&dW\rU1sg&twm\u0018\u0013fcR!\u00111AA\u0005!\rY\u0016QA\u0005\u0004\u0003\u000fa&\u0001B+oSRD\u0001\"a\u0003\b\u0003\u0003\u0005\r\u0001`\u0001\u0004q\u0012\n\u0014a\u00049s_\u001aLG.\u001a)beNLgn\u001a\u0011\u0002=\r|W.\\8o'V\u0014W\t\u001f9sKN\u001c\u0018n\u001c8FY&l\u0017N\\1uS>t\u0017AI2p[6|gnU;c\u000bb\u0004(/Z:tS>tW\t\\5nS:\fG/[8o?\u0012*\u0017\u000f\u0006\u0003\u0002\u0004\u0005U\u0001\u0002CA\u0006\u0015\u0005\u0005\t\u0019\u0001?\u0002?\r|W.\\8o'V\u0014W\t\u001f9sKN\u001c\u0018n\u001c8FY&l\u0017N\\1uS>t\u0007%\u0001\teK\n,xmZ3s\u000bb,7-\u001e;peV\u0011\u0011Q\u0004\t\u0005\u0003?\ti#\u0004\u0002\u0002\")!\u00111EA\u0013\u0003\u0019\u0019XM\u001d<fe*!\u0011qEA\u0015\u0003!!WMY;hO\u0016\u0014(bAA\u0016!\u0006Y\u0011N\u001c;feB\u0014X\r^3e\u0013\u0011\ty#!\t\u0003+]+\u0017M^3EK\n,xmZ3s\u000bb,7-\u001e;pe\u0006!B-\u001a2vO\u001e,'/\u0012=fGV$xN]0%KF$B!a\u0001\u00026!I\u00111B\u0007\u0002\u0002\u0003\u0007\u0011QD\u0001\u0012I\u0016\u0014WoZ4fe\u0016CXmY;u_J\u0004\u0013\u0001\u00043fEV<w-\u001a:Q_J$XCAA\u001f!\rY\u0016qH\u0005\u0004\u0003\u0003b&aA%oi\u0006\u0001B-\u001a2vO\u001e,'\u000fU8si~#S-\u001d\u000b\u0005\u0003\u0007\t9\u0005C\u0005\u0002\fA\t\t\u00111\u0001\u0002>\u0005iA-\u001a2vO\u001e,'\u000fU8si\u0002\nQ\u0001Z3ck\u001e\f\u0011\u0002Z3ck\u001e|F%Z9\u0015\t\u0005\r\u0011\u0011\u000b\u0005\t\u0003\u0017\u0019\u0012\u0011!a\u0001y\u00061A-\u001a2vO\u0002\n!#\\=X_J\\\u0017N\\4ESJ,7\r^8ssV\u0011\u0011\u0011\f\t\u0005\u00037\n\t'\u0004\u0002\u0002^)\u0019\u0011qL8\u0002\u0005%|\u0017\u0002BA2\u0003;\u0012AAR5mK\u00061R._,pe.Lgn\u001a#je\u0016\u001cGo\u001c:z?\u0012*\u0017\u000f\u0006\u0003\u0002\u0004\u0005%\u0004\"CA\u0006-\u0005\u0005\t\u0019AA-\u0003Mi\u0017pV8sW&tw\rR5sK\u000e$xN]=!\u0003Ai\u0017\u0010T8hO&twmU3sm&\u001cW-\u0006\u0002\u0002rA)1,a\u001d\u0002x%\u0019\u0011Q\u000f/\u0003\r=\u0003H/[8o!\u0011\tI(a!\u000e\u0005\u0005m$\u0002BA?\u0003\u007f\nqa]3sm&\u001cWMC\u0002\u0002\u0002B\u000bQ!\\8eK2LA!!\"\u0002|\tqAj\\4hS:<7+\u001a:wS\u000e,\u0017\u0001F7z\u0019><w-\u001b8h'\u0016\u0014h/[2f?\u0012*\u0017\u000f\u0006\u0003\u0002\u0004\u0005-\u0005\"CA\u00063\u0005\u0005\t\u0019AA9\u0003Ei\u0017\u0010T8hO&twmU3sm&\u001cW\rI\u0001\u0017a\u0006\u00148/\u001b8h\u001b\u0016$(/[2t\u0019&\u001cH/\u001a8feV\u0011\u00111\u0013\t\u0005\u0003+\u000b\u0019+\u0004\u0002\u0002\u0018*!\u0011\u0011TAN\u0003\u001diW\r\u001e:jGNTA!!(\u0002 \u0006)\u0001\u000f[1tK*\u0019\u0011\u0011\u0015)\u0002\rA\f'o]3s\u0013\u0011\t)+a&\u0003?A\u000b'o]5oO6+GO]5dg\u000e{G\u000e\\3di>\u0014H*[:uK:,'/\u0001\u000eqCJ\u001c\u0018N\\4NKR\u0014\u0018nY:MSN$XM\\3s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0004\u0005-\u0006\"CA\u00069\u0005\u0005\t\u0019AAJ\u0003]\u0001\u0018M]:j]\u001elU\r\u001e:jGNd\u0015n\u001d;f]\u0016\u0014\b\u0005F\u0001w)\u00151\u00181WA[\u0011\u0015\u0001w\u00041\u0001b\u0011\u0015)w\u00041\u0001g)\r1\u0018\u0011\u0018\u0005\u0006A\u0002\u0002\r!Y\u0001\nI\u0016\u0014Wo\u001a)peR$B!a\u0001\u0002@\"9\u0011\u0011Y\u0011A\u0002\u0005u\u0012A\u00039peRtU/\u001c2fe\u0006\t2\u000f^1si\u0012+'-^4TKN\u001c\u0018n\u001c8\u0015\u0005\u0005\r\u0011aC3oC\ndW\rR3ck\u001e\fQ\"[:EK\n,x-\u00128bE2,G#\u0001?\u0002\u0011Y\fG.\u001b3bi\u0016$b!!5\u0002X\u0006\u0005\bc\u00012\u0002T&\u0019\u0011Q\u001b(\u0003!Y\u000bG.\u001b3bi&|gNU3tk2$\bbBAmK\u0001\u0007\u00111\\\u0001\no\u0016\fg/\u001a$jY\u0016\u00042AYAo\u0013\r\tyN\u0014\u0002\n/\u0016\fg/\u001a$jY\u0016Dq!a9&\u0001\u0004\t)/\u0001\u0004d_:4\u0017n\u001a\t\u0004E\u0006\u001d\u0018bAAu\u001d\n9b+\u00197jI\u0006$\u0018n\u001c8D_:4\u0017nZ;sCRLwN\\\u0001\u0015o&$\bnV8sW&tw\rR5sK\u000e$xN]=\u0015\u0007Y\fy\u000fC\u0004\u0002r\u001a\u0002\r!!\u0017\u0002!]|'o[5oO\u0012K'/Z2u_JLHCAA-\u00035!WMY;h\u000bb,7-\u001e;peR\u0011\u0011QD\u0001\rI&\u001c\u0018M\u00197f\t\u0016\u0014WoZ\u0001\u0013o&$\b\u000eT8hO&twmU3sm&\u001cW\rF\u0002w\u0003\u007fDqA!\u0001+\u0001\u0004\t9(\u0001\bm_\u001e<\u0017N\\4TKJ4\u0018nY3\u0015\u0005\u0005E\u0014\u0001F3oC\ndW\r\u0015:pM&dW\rU1sg&tw-A\u000beSN\f'\r\\3Qe>4\u0017\u000e\\3QCJ\u001c\u0018N\\4\u0002K\u0011L7/\u00192mK\u000e{W.\\8o'V\u0014W\t\u001f9sKN\u001c\u0018n\u001c8FY&l\u0017N\\1uS>t\u0017\u0001J3oC\ndWmQ8n[>t7+\u001e2FqB\u0014Xm]:j_:,E.[7j]\u0006$\u0018n\u001c8\u0002\u000f\r|W\u000e]5mKR\u0001\"\u0011\u0003B\f\u0005O\u0011YDa\u0013\u0003f\tU$q\u0010\t\u0004E\nM\u0011b\u0001B\u000b\u001d\nyA)\u0019;b/\u0016\fg/Z*de&\u0004H\u000fC\u0004\u0003\u001aA\u0002\rAa\u0007\u0002\rM|WO]2f!\u0011\u0011iBa\t\u000e\u0005\t}!b\u0001B\u0011!\u0006\u00191\u000fZ6\n\t\t\u0015\"q\u0004\u0002\u000e/\u0016\fg/\u001a*fg>,(oY3\t\u000f\t%\u0002\u00071\u0001\u0003,\u0005Q\u0011\u000eZ3oi&4\u0017.\u001a:\u0011\t\t5\"qG\u0007\u0003\u0005_QAA!\r\u00034\u0005Ia/\u0019:jC\ndWm\u001d\u0006\u0005\u0005k\ty*A\u0002bgRLAA!\u000f\u00030\tqa*Y7f\u0013\u0012,g\u000e^5gS\u0016\u0014\bb\u0002B\u001fa\u0001\u0007!qH\u0001\u000fS6\u0004H.[2ji&s\u0007/\u001e;t!\u0015Y&\u0011\tB#\u0013\r\u0011\u0019\u0005\u0018\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004E\n\u001d\u0013b\u0001B%\u001d\nI\u0011J\u001c9viRK\b/\u001a\u0005\b\u0005\u001b\u0002\u0004\u0019\u0001B(\u0003U!WMZ1vYR|U\u000f\u001e9vi6KW.\u001a+za\u0016\u0004BA!\u0015\u0003`9!!1\u000bB.!\r\u0011)\u0006X\u0007\u0003\u0005/R1A!\u0017Y\u0003\u0019a$o\\8u}%\u0019!Q\f/\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011\tGa\u0019\u0003\rM#(/\u001b8h\u0015\r\u0011i\u0006\u0018\u0005\b\u0005O\u0002\u0004\u0019\u0001B5\u0003]!WMZ1vYR<&/\u001b;feB\u0013x\u000e]3si&,7\u000f\u0005\u0005\u0003R\t-$q\nB8\u0013\u0011\u0011iGa\u0019\u0003\u00075\u000b\u0007\u000fE\u0002\\\u0005cJ1Aa\u001d]\u0005\r\te.\u001f\u0005\b\u0005o\u0002\u0004\u0019\u0001B=\u0003\u001di\u0017\r\u001f+j[\u0016\u00042a\u0017B>\u0013\r\u0011i\b\u0018\u0002\u0005\u0019>tw\rC\u0004\u0003\u0002B\u0002\rAa!\u0002!\u0011\fG/Y,fCZ,g+\u001a:tS>t\u0007#B.\u0002t\t\u0015\u0005\u0003\u0002BD\u0005\u001bk!A!#\u000b\u0007\t-\u0005+A\u0003vi&d7/\u0003\u0003\u0003\u0010\n%%\u0001\u0005#bi\u0006<V-\u0019<f-\u0016\u00148/[8o\u0003Q\u0019'/Z1uKB\u000b'o]5oO\u000e{g\u000e^3yiRQ!Q\u0013BO\u0005?\u0013IKa+\u0011\t\t]%\u0011T\u0007\u0003\u00037KAAa'\u0002\u001c\nq\u0001+\u0019:tS:<7i\u001c8uKb$\bb\u0002B\u0015c\u0001\u0007!1\u0006\u0005\b\u0005C\u000b\u0004\u0019\u0001BR\u00035\u0001\u0018M]:fe6\u000bg.Y4feB!!q\u0013BS\u0013\u0011\u00119+a'\u000355{G-\u001e7f!\u0006\u00148/\u001b8h!\"\f7/Z:NC:\fw-\u001a:\t\u0013\t]\u0014\u0007%AA\u0002\te\u0004\"\u0003BAcA\u0005\t\u0019\u0001BB\u0003y\u0019'/Z1uKB\u000b'o]5oO\u000e{g\u000e^3yi\u0012\"WMZ1vYR$3'\u0006\u0002\u00032*\"!\u0011\u0010BZW\t\u0011)\f\u0005\u0003\u00038\n\u0005WB\u0001B]\u0015\u0011\u0011YL!0\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B`9\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\r'\u0011\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AH2sK\u0006$X\rU1sg&twmQ8oi\u0016DH\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011IM\u000b\u0003\u0003\u0004\nM\u0016AE2p[BLG.\u0019;j_:lU\r\u001e:jGN$\"Aa4\u0011\t\u0005U%\u0011[\u0005\u0005\u0005'\f9J\u0001\nD_6\u0004\u0018\u000e\\1uS>tW*\u001a;sS\u000e\u001c\u0018aC5oM\u0016\u0014H+\u001f9f\u001f\u001a$BA!7\u0003hB)1,a\u001d\u0003\\B!!Q\u001cBr\u001b\t\u0011yNC\u0002\u0003bB\u000b!\u0001^:\n\t\t\u0015(q\u001c\u0002\n/\u0016\fg/\u001a+za\u0016DqA!;6\u0001\u0004\u0011y%\u0001\u0004tGJL\u0007\u000f^\u0001\n]\u0016<8i\u001c8gS\u001e$\"Aa<\u0011\u0007\t\u0014\t0C\u0002\u0003t:\u0013\u0011cQ8na&d\u0017\r^5p]\u000e{gNZ5h\u0003-\u0019w.\u001c9jY\u0016<\u0016\u000e\u001e5\u0015\t\tE!\u0011 \u0005\b\u0003G<\u0004\u0019\u0001Bx)\u0011\u0011\tB!@\t\u000f\t}\b\b1\u0001\u0002Z\u0005!a-\u001b7f)\u0019\u0011\tba\u0001\u0004\u0006!9!q`\u001dA\u0002\u0005e\u0003b\u0002B\u001fs\u0001\u0007!q\b\u000b\u0007\u0005#\u0019Ia!\u0004\t\u000f\r-!\b1\u0001\u0003,\u0005qa.Y7f\u0013\u0012,g\u000e^5gS\u0016\u0014\bb\u0002B\u001fu\u0001\u0007!q\b\u000b\u0005\u0005#\u0019\t\u0002C\u0004\u0004\fm\u0002\rAa\u000b\u0015\u0011\tE1QCB\f\u00073AqA!;=\u0001\u0004\u0011y\u0005C\u0004\u0004\fq\u0002\rAa\u000b\t\u000f\tuB\b1\u0001\u0003@QQ!\u0011CB\u000f\u0007?\u0019\tca\t\t\u000f\t%X\b1\u0001\u0003P!911B\u001fA\u0002\t-\u0002b\u0002B\u001f{\u0001\u0007!q\b\u0005\b\u0005\u001bj\u0004\u0019\u0001B()1\u0011\tba\n\u0004*\r-2QFB\u0018\u0011\u001d\u0011IO\u0010a\u0001\u0005\u001fBqaa\u0003?\u0001\u0004\u0011Y\u0003C\u0004\u0003>y\u0002\rAa\u0010\t\u000f\t5c\b1\u0001\u0003P!9!q\r A\u0002\t%DC\u0002B\t\u0007g\u0019)\u0004C\u0004\u0003\u0000~\u0002\r!!\u0017\t\u000f\tur\b1\u0001\u00048A)1L!\u0011\u0003PQ1!\u0011CB\u001e\u0007\u0017Bqa!\u0010A\u0001\u0004\u0019y$A\u0002ve2\u0004Ba!\u0011\u0004H5\u001111\t\u0006\u0004\u0007\u000bz\u0017a\u00018fi&!1\u0011JB\"\u0005\r)&\u000b\u0014\u0005\b\u0005{\u0001\u0005\u0019AB\u001c)\u0019\u0011\tba\u0014\u0004R!9!\u0011^!A\u0002\t=\u0003bBB\u0006\u0003\u0002\u0007!q\n\u000b\u0007\u0005#\u0019)fa\u0016\t\u000f\t%(\t1\u0001\u0003P!911\u0002\"A\u0002\t-B\u0003\u0003B\t\u00077\u001aifa\u0018\t\u000f\t%8\t1\u0001\u0003P!911B\"A\u0002\t-\u0002bBB1\u0007\u0002\u0007!QQ\u0001\u000eY\u0006tw-^1hK2+g/\u001a7\u0015\t\tE1Q\r\u0005\b\u0005S$\u0005\u0019\u0001B()\u0019\u0011\tb!\u001b\u0004l!9!\u0011^#A\u0002\t=\u0003b\u0002B\u001f\u000b\u0002\u00071q\u0007\u0015\u0006\u0001\r=41\u0010\t\u0005\u0007c\u001a9(\u0004\u0002\u0004t)\u00191Q\u000f)\u0002\u0017\u0005tgn\u001c;bi&|gn]\u0005\u0005\u0007s\u001a\u0019H\u0001\u0005XK\u00064X-\u00119jc-y2QPBJ\u0007;\u001c)o!<\u0011\r\r}4QQBE\u001b\t\u0019\tIC\u0002\u0004\u0004r\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u00199i!!\u0003\u0007M+\u0017\u000f\u0005\u0003\u0004\f\u000eEUBABG\u0015\r\u0019yi\\\u0001\u0005Y\u0006tw-\u0003\u0003\u0003b\r5\u0015g\u0002\u0010\u0004\u0016\u000e561\u001c\u000b\u0005\u0007{\u001a9\nC\u0004\u0004\u001ab\u0003\raa*\u0002\u000b\u0015dW-\\:\n\t\ru5qT\u0001\u0006CB\u0004H._\u0005\u0005\u0007C\u001b\u0019K\u0001\tHK:,'/[2D_6\u0004\u0018M\\5p]*!1QUBA\u0003\u001d9WM\\3sS\u000e\u0004RaWBU\u0007\u0013K1aa+]\u0005)a$/\u001a9fCR,GMP\u0019\nG\r=61TBe\u0007;+Ba!-\u0004:R!11WBc!\u0019\u0019yh!\"\u00046B!1qWB]\u0019\u0001!qaa/Y\u0005\u0004\u0019iLA\u0001B#\u0011\u0019yLa\u001c\u0011\u0007m\u001b\t-C\u0002\u0004Dr\u0013qAT8uQ&tw\rC\u0004\u0004\u001ab\u0003\raa2\u0011\u000bm\u001bIk!.2\u0013\r\u001aYma4\u0004T\u000eEg\u0002BBg\u0007\u001f\u00042aWBA\u0013\u0011\u0019\tn!!\u0002\u0007M+\u0017/M\u0005$\u0007\u001b\u001c)na6\u0004\u0004&\u001911\u0011/2\r\u0011\u0012\u0019f!7^\u0013\u0005i\u0016g\u0001\u0014\u0004\nF*Qea8\u0004b>\u00111\u0011]\u0011\u0003\u0007G\f1AQ1uc\u0015)3q]Bu\u001f\t\u0019I/\t\u0002\u0004l\u000611\u000b^;eS>\fT!JBx\u0007c|!a!=\"\u0005\rM\u0018\u0001\u00053bi\u0006ls/Z1wK6\nw-\u001a8u\u0003a!\u0015\r^1XK\u00064XmU2sSB$\u0018N\\4F]\u001eLg.\u001a\t\u0003E\u001e\u001b\"a\u0012.\u0015\u0005\r]H#\u0002<\u0004\u0000\u0012\u0005\u0001\"\u00021J\u0001\u0004\t\u0007\"B3J\u0001\u00041Gc\u0001<\u0005\u0006!)\u0001M\u0013a\u0001C\u0006)qO]5uKR1A1\u0002C\t\t'\u00012A\u0019C\u0007\u0013\r!yA\u0014\u0002\u0010\t\u0006$\u0018mV3bm\u0016\u0014Vm];mi\"9!\u0011\u001e'A\u0002\t=\u0003b\u0002C\u000b\u0019\u0002\u0007AqC\u0001\tE&tG-\u001b8hgB\u0019!\r\"\u0007\n\u0007\u0011maJA\tTGJL\u0007\u000f^5oO\nKg\u000eZ5oON\u0004")
public class DataWeaveScriptingEngine {
    private final ModuleComponentsFactory componentsFactory;
    private final ParserConfiguration parsingConfiguration;
    private final Properties configuration;
    private boolean profileParsing;
    private boolean commonSubExpressionElimination;
    private WeaveDebuggerExecutor debuggerExecutor;
    private int debuggerPort;
    private boolean debug;
    private File myWorkingDirectory;
    private Option<LoggingService> myLoggingService;
    private ParsingMetricsCollectorListener parsingMetricsListener;

    public static DataWeaveResult write(String string, ScriptingBindings scriptingBindings) {
        return DataWeaveScriptingEngine$.MODULE$.write(string, scriptingBindings);
    }

    public static DataWeaveScriptingEngine apply() {
        return DataWeaveScriptingEngine$.MODULE$.apply();
    }

    public static DataWeaveScriptingEngine apply(ModuleComponentsFactory moduleComponentsFactory) {
        return DataWeaveScriptingEngine$.MODULE$.apply(moduleComponentsFactory);
    }

    public static DataWeaveScriptingEngine apply(ModuleComponentsFactory moduleComponentsFactory, ParserConfiguration parserConfiguration) {
        return DataWeaveScriptingEngine$.MODULE$.apply(moduleComponentsFactory, parserConfiguration);
    }

    public Properties configuration() {
        return this.configuration;
    }

    private boolean profileParsing() {
        return this.profileParsing;
    }

    private void profileParsing_$eq(boolean x$1) {
        this.profileParsing = x$1;
    }

    private boolean commonSubExpressionElimination() {
        return this.commonSubExpressionElimination;
    }

    private void commonSubExpressionElimination_$eq(boolean x$1) {
        this.commonSubExpressionElimination = x$1;
    }

    private WeaveDebuggerExecutor debuggerExecutor() {
        return this.debuggerExecutor;
    }

    private void debuggerExecutor_$eq(WeaveDebuggerExecutor x$1) {
        this.debuggerExecutor = x$1;
    }

    private int debuggerPort() {
        return this.debuggerPort;
    }

    private void debuggerPort_$eq(int x$1) {
        this.debuggerPort = x$1;
    }

    private boolean debug() {
        return this.debug;
    }

    private void debug_$eq(boolean x$1) {
        this.debug = x$1;
    }

    private File myWorkingDirectory() {
        return this.myWorkingDirectory;
    }

    private void myWorkingDirectory_$eq(File x$1) {
        this.myWorkingDirectory = x$1;
    }

    private Option<LoggingService> myLoggingService() {
        return this.myLoggingService;
    }

    private void myLoggingService_$eq(Option<LoggingService> x$1) {
        this.myLoggingService = x$1;
    }

    private ParsingMetricsCollectorListener parsingMetricsListener() {
        return this.parsingMetricsListener;
    }

    private void parsingMetricsListener_$eq(ParsingMetricsCollectorListener x$1) {
        this.parsingMetricsListener = x$1;
    }

    public void debugPort(int portNumber) {
        this.debuggerPort_$eq(portNumber);
    }

    private void startDebugSession() {
        DefaultWeaveDebuggingSession session = new DefaultWeaveDebuggingSession(TcpServerProtocol$.MODULE$.apply(this.debuggerPort()));
        this.debuggerExecutor_$eq(new WeaveDebuggerExecutor(session));
        session.start(this.debuggerExecutor());
    }

    public void enableDebug() {
        this.debug_$eq(true);
    }

    public boolean isDebugEnable() {
        return this.debug();
    }

    public ValidationResult validate(WeaveFile weaveFile, ValidationConfiguration config) {
        DocumentParser documentParser = new DocumentParser(DocumentParser$.MODULE$.$lessinit$greater$default$1(), DocumentParser$.MODULE$.$lessinit$greater$default$2());
        ModuleComponents components = this.componentsFactory.createComponents();
        DefaultWeaveResource resource = new DefaultWeaveResource(weaveFile.url(), weaveFile.content());
        NameIdentifier x$1 = weaveFile.nameIdentifier();
        ModuleParsingPhasesManager x$2 = components.parser();
        Option<DataWeaveVersion> x$3 = config.version();
        long x$4 = this.createParsingContext$default$3();
        ParsingContext parsingContext = this.createParsingContext(x$1, x$2, x$4, x$3);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])config.implicitInputs())).foreach((Function1 & Serializable & scala.Serializable)input -> parsingContext.addImplicitInput(input.name(), input.weaveType()));
        PhaseResult result = config.phase() == ValidationPhase$.MODULE$.PARSE() ? documentParser.parse((WeaveResource)resource, parsingContext) : (config.phase() == ValidationPhase$.MODULE$.SCOPE() ? documentParser.runScopePhases((WeaveResource)resource, parsingContext) : documentParser.runAllPhases((WeaveResource)resource, parsingContext));
        boolean successful = result.hasResult();
        ValidationMessage[] errors = (ValidationMessage[])((TraversableOnce)result.errorMessages().map((Function1 & Serializable & scala.Serializable)pair -> new ValidationMessage((WeaveLocation)pair._1(), (Message)pair._2()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ValidationMessage.class));
        ValidationMessage[] warnings = (ValidationMessage[])((TraversableOnce)result.warningMessages().map((Function1 & Serializable & scala.Serializable)pair -> new ValidationMessage((WeaveLocation)pair._1(), (Message)pair._2()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ValidationMessage.class));
        return new ValidationResult(successful, errors, warnings);
    }

    public DataWeaveScriptingEngine withWorkingDirectory(File workingDirectory) {
        this.myWorkingDirectory_$eq(workingDirectory);
        return this;
    }

    public File workingDirectory() {
        return this.myWorkingDirectory();
    }

    public WeaveDebuggerExecutor debugExecutor() {
        block0: {
            if (this.debuggerExecutor() != null) break block0;
            this.startDebugSession();
        }
        return this.debuggerExecutor();
    }

    public DataWeaveScriptingEngine disableDebug() {
        this.debug_$eq(false);
        return this;
    }

    public DataWeaveScriptingEngine withLoggingService(LoggingService loggingService) {
        this.myLoggingService_$eq((Option<LoggingService>)Option$.MODULE$.apply((Object)loggingService));
        return this;
    }

    public Option<LoggingService> loggingService() {
        return this.myLoggingService();
    }

    public DataWeaveScriptingEngine enableProfileParsing() {
        this.profileParsing_$eq(true);
        return this;
    }

    public DataWeaveScriptingEngine disableProfileParsing() {
        this.profileParsing_$eq(false);
        return this;
    }

    public DataWeaveScriptingEngine disableCommonSubExpressionElimination() {
        this.commonSubExpressionElimination_$eq(false);
        return this;
    }

    public DataWeaveScriptingEngine enableCommonSubExpressionElimination() {
        this.commonSubExpressionElimination_$eq(true);
        return this;
    }

    private DataWeaveScript compile(WeaveResource source, NameIdentifier identifier, InputType[] implicitInputs, String defaultOutputMimeType, Map<String, Object> defaultWriterProperties, long maxTime, Option<DataWeaveVersion> dataWeaveVersion) {
        PhaseResult<CompilationResult<DocumentNode>> phaseResult;
        ModuleComponents components = this.componentsFactory.createComponents();
        ParsingContext parsingContext = this.createParsingContext(identifier, components.parser(), maxTime, dataWeaveVersion);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])implicitInputs)).foreach((Function1 & Serializable & scala.Serializable)input -> parsingContext.addImplicitInput(input.name(), input.weaveType()));
        this.parsingConfiguration.implicitImports().foreach((Function1 & Serializable & scala.Serializable)moduleName -> parsingContext.addImplicitImport(moduleName));
        this.parsingConfiguration.parsingAnnotationProcessors().foreach((Function1 & Serializable & scala.Serializable)annotationRegistry -> parsingContext.registerAnnotationProcessor((NameIdentifier)annotationRegistry._1(), (DWAnnotationProcessor)annotationRegistry._2()));
        if (!this.commonSubExpressionElimination()) {
            parsingContext.disableCommonSubExpressionElimination();
        }
        if (this.parsingConfiguration.skipVerifications()) {
            parsingContext.skipVerification_$eq(this.parsingConfiguration.skipVerifications());
            phaseResult = WeaveCompiler$.MODULE$.compileWithNoCheck(source, parsingContext, components.compiler());
        } else {
            phaseResult = WeaveCompiler$.MODULE$.compile(source, parsingContext, components.compiler());
        }
        PhaseResult<CompilationResult<DocumentNode>> value = phaseResult;
        value.warningMessages().foreach((Function1 & Serializable & scala.Serializable)warn -> this.myLoggingService().map((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.logWarn(Message$.MODULE$.toMessageString((WeaveLocation)warn._1(), (Message)warn._2()));
            return BoxedUnit.UNIT;
        }));
        return new DataWeaveScript(((CompilationResult)value.getResult()).executable(), identifier, this, components, this.myLoggingService(), (Option<File>)Option$.MODULE$.apply((Object)this.myWorkingDirectory()), defaultOutputMimeType, defaultWriterProperties, dataWeaveVersion).maxTime(maxTime);
    }

    private ParsingContext createParsingContext(NameIdentifier identifier, ModuleParsingPhasesManager parserManager, long maxTime, Option<DataWeaveVersion> dataWeaveVersion) {
        BoxedUnit boxedUnit;
        ParsingContext parsingContext = ParsingContext$.MODULE$.apply(identifier, parserManager, 1, false);
        if (this.profileParsing()) {
            this.parsingMetricsListener_$eq(new ParsingMetricsCollectorListener(ParsingMetricsCollectorListener$.MODULE$.$lessinit$greater$default$1()));
            boxedUnit = parsingContext.notificationManager().addListener((ParsingNotificationListener)this.parsingMetricsListener());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object = maxTime > -1L ? parsingContext.notificationManager().addListener((ParsingNotificationListener)new WatchdogParsingListener(maxTime)) : BoxedUnit.UNIT;
        Object object2 = dataWeaveVersion.isDefined() ? parsingContext.withLanguageLevel(((DataWeaveVersion)dataWeaveVersion.get()).asSVersion()) : BoxedUnit.UNIT;
        return parsingContext;
    }

    private long createParsingContext$default$3() {
        return -1L;
    }

    private Option<DataWeaveVersion> createParsingContext$default$4() {
        return None$.MODULE$;
    }

    public CompilationMetrics compilationMetrics() {
        if (this.parsingMetricsListener() != null) {
            return this.parsingMetricsListener().metrics();
        }
        return null;
    }

    public Option<WeaveType> inferTypeOf(String script) {
        ModuleComponents components = this.componentsFactory.createComponents();
        ParsingContext parsingContext = this.createParsingContext(NameIdentifier$.MODULE$.ANONYMOUS_NAME(), components.parser(), this.createParsingContext$default$3(), this.createParsingContext$default$4());
        PhaseResult mayBeParserResult = MappingParser$.MODULE$.parse(MappingParser$.MODULE$.typeCheckPhase(), WeaveResourceFactory$.MODULE$.fromContent(script), parsingContext);
        return mayBeParserResult.mayBeResult().flatMap((Function1 & Serializable & scala.Serializable)result -> result.typeGraph().findNode(((DocumentNode)result.astNode()).root()).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.resultType()));
    }

    public CompilationConfig newConfig() {
        return new CompilationConfig(this.componentsFactory);
    }

    public DataWeaveScript compileWith(CompilationConfig config) {
        return this.compile(config.getResource(), config.getIdentifier(), config.getInputs(), config.getDefaultOutputMimeType(), config.getDefaultWriterProperties(), config.getMaxTime(), config.getVersion());
    }

    public DataWeaveScript compile(File file) {
        CompilationConfig config = this.newConfig().withFile(file);
        return this.compileWith(config);
    }

    public DataWeaveScript compile(File file, InputType[] implicitInputs) {
        CompilationConfig config = this.newConfig().withFile(file).withInputs(implicitInputs);
        return this.compileWith(config);
    }

    public DataWeaveScript compile(NameIdentifier nameIdentifier, InputType[] implicitInputs) {
        CompilationConfig config = this.newConfig().withNameIdentifier(nameIdentifier).withInputs(implicitInputs);
        return this.compileWith(config);
    }

    public DataWeaveScript compile(NameIdentifier nameIdentifier) {
        CompilationConfig config = this.newConfig().withNameIdentifier(nameIdentifier);
        return this.compileWith(config);
    }

    public DataWeaveScript compile(String script, NameIdentifier nameIdentifier, InputType[] implicitInputs) {
        CompilationConfig config = this.newConfig().withScript(script).withNameIdentifier(nameIdentifier).withInputs(implicitInputs);
        return this.compileWith(config);
    }

    public DataWeaveScript compile(String script, NameIdentifier nameIdentifier, InputType[] implicitInputs, String defaultOutputMimeType) {
        CompilationConfig config = this.newConfig().withScript(script).withNameIdentifier(nameIdentifier).withInputs(implicitInputs).withDefaultOutputType(defaultOutputMimeType);
        return this.compileWith(config);
    }

    public DataWeaveScript compile(String script, NameIdentifier nameIdentifier, InputType[] implicitInputs, String defaultOutputMimeType, Map<String, Object> defaultWriterProperties) {
        CompilationConfig config = this.newConfig().withScript(script).withNameIdentifier(nameIdentifier).withInputs(implicitInputs).withDefaultOutputType(defaultOutputMimeType).withDefaultWriterProperties(defaultWriterProperties);
        return this.compileWith(config);
    }

    public DataWeaveScript compile(File file, String[] implicitInputs) {
        CompilationConfig config = this.newConfig().withFile(file).withInputs((InputType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])implicitInputs)).map((Function1 & Serializable & scala.Serializable)x$3 -> new InputType((String)x$3, (Option<WeaveType>)None$.MODULE$), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InputType.class))));
        return this.compileWith(config);
    }

    public DataWeaveScript compile(URL url, String[] implicitInputs) {
        CompilationConfig config = this.newConfig().withUrl(url).withInputs(implicitInputs);
        return this.compileWith(config);
    }

    public DataWeaveScript compile(String script, String nameIdentifier) {
        CompilationConfig config = this.newConfig().withScript(script).withNameIdentifier(nameIdentifier);
        return this.compileWith(config);
    }

    public DataWeaveScript compile(String script, NameIdentifier nameIdentifier) {
        CompilationConfig config = this.newConfig().withScript(script).withNameIdentifier(nameIdentifier);
        return this.compileWith(config);
    }

    public DataWeaveScript compile(String script, NameIdentifier nameIdentifier, DataWeaveVersion languageLevel) {
        CompilationConfig config = this.newConfig().withScript(script).withNameIdentifier(nameIdentifier).withLanguageVersion(languageLevel);
        return this.compileWith(config);
    }

    public DataWeaveScript compile(String script) {
        CompilationConfig config = this.newConfig().withScript(script);
        return this.compileWith(config);
    }

    public DataWeaveScript compile(String script, String[] implicitInputs) {
        CompilationConfig config = this.newConfig().withScript(script).withInputs(implicitInputs);
        return this.compileWith(config);
    }

    public DataWeaveScriptingEngine(ModuleComponentsFactory componentsFactory, ParserConfiguration parsingConfiguration, Properties configuration) {
        this.componentsFactory = componentsFactory;
        this.parsingConfiguration = parsingConfiguration;
        this.configuration = configuration;
        this.profileParsing = false;
        this.commonSubExpressionElimination = true;
        this.debuggerPort = TcpServerProtocol$.MODULE$.DEFAULT_PORT();
        this.debug = false;
        this.myLoggingService = None$.MODULE$;
    }

    public DataWeaveScriptingEngine() {
        this(DynamicModuleComponentFactory$.MODULE$.apply(), new ParserConfiguration(ParserConfiguration$.MODULE$.apply$default$1(), ParserConfiguration$.MODULE$.apply$default$2(), ParserConfiguration$.MODULE$.apply$default$3()), System.getProperties());
    }

    public DataWeaveScriptingEngine(ModuleComponentsFactory componentsFactory, ParserConfiguration parsingConfiguration) {
        this(componentsFactory, parsingConfiguration, System.getProperties());
    }

    public DataWeaveScriptingEngine(ModuleComponentsFactory componentsFactory) {
        this(componentsFactory, new ParserConfiguration(ParserConfiguration$.MODULE$.$lessinit$greater$default$1(), ParserConfiguration$.MODULE$.$lessinit$greater$default$2(), ParserConfiguration$.MODULE$.$lessinit$greater$default$3()), System.getProperties());
    }
}

