package org.mule.weave.v2.interpreted.marker

import org.mule.weave.v2.interpreted.InterpreterPreCompilerMarker
import org.mule.weave.v2.parser.annotation.AstNodeAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.AstNodeHelper
import org.mule.weave.v2.parser.ast.structure.ArrayNode
import org.mule.weave.v2.parser.ast.structure.KeyNode
import org.mule.weave.v2.parser.ast.structure.KeyValuePairNode
import org.mule.weave.v2.parser.ast.structure.ObjectNode
import org.mule.weave.v2.parser.phase.ParsingContext
import org.mule.weave.v2.scope.ScopesNavigator

class LiteralValueMarker extends InterpreterPreCompilerMarker {

  override def mark(node: AstNode, scope: ScopesNavigator, context: ParsingContext): Unit = {
    node match {
      case an: ArrayNode =>
        if (!an.isAnnotatedWith(classOf[LiteralNodeAnnotation])) {
          if (AstNodeHelper.isArrayLiteral(an, scope)) {
            an.annotate(new LiteralNodeAnnotation())
          }
        }
      case kvp: KeyValuePairNode =>
        if (!kvp.key.isAnnotatedWith(classOf[LiteralNodeAnnotation])) {
          if (AstNodeHelper.isLiteralKey(kvp.key, scope)) {
            kvp.key.annotate(new LiteralNodeAnnotation())
          }
        }
      case key: KeyNode =>
        if (!key.isAnnotatedWith(classOf[LiteralNodeAnnotation])) {
          if (AstNodeHelper.isLiteralKey(key, scope)) {
            key.annotate(new LiteralNodeAnnotation())
          }
        }
        if (key.ns.isDefined) {
          val ns = key.ns.get
          if (!ns.isAnnotatedWith(classOf[LiteralNodeAnnotation])) {
            if (AstNodeHelper.isLiteralNamespace(key.ns, scope)) {
              ns.annotate(new LiteralNodeAnnotation())
            }
          }
        }
      case on: ObjectNode =>
        if (!on.isAnnotatedWith(classOf[LiteralNodeAnnotation])) {
          if (AstNodeHelper.isObjectLiteral(on, scope)) {
            on.annotate(new LiteralNodeAnnotation())
          }
        }
      case _ =>
      // Nothing to do
    }

  }
}

class LiteralNodeAnnotation extends AstNodeAnnotation {

  override def name(): String = {
    "LiteralNode"
  }
}