package org.mule.weave.v2.interpreted.marker

import org.mule.weave.v2.grammar.AsOpId
import org.mule.weave.v2.interpreted.InterpreterPreCompilerMarker
import org.mule.weave.v2.parser.annotation.AstNodeAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.functions.FunctionNode
import org.mule.weave.v2.parser.ast.operators.BinaryOpNode
import org.mule.weave.v2.parser.ast.patterns.TypePatternNode
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode
import org.mule.weave.v2.parser.phase.ParsingContext
import org.mule.weave.v2.scope.ScopesNavigator
import org.mule.weave.v2.ts.TypeHelper
import org.mule.weave.v2.ts.WeaveType

class RequiresMaterializationMarker extends InterpreterPreCompilerMarker {

  override def mark(node: AstNode, scope: ScopesNavigator, context: ParsingContext): Unit = {
    node match {
      case bon: BinaryOpNode =>
        bon.binaryOpId match {
          case AsOpId =>
            if (!bon.rhs.isAnnotatedWith(classOf[RequiresMaterializationAnnotation])) {
              if (TypeHelper.requiredMaterialize(WeaveType(bon.rhs.asInstanceOf[WeaveTypeNode], scope.referenceResolver))) {
                bon.rhs.annotate(new RequiresMaterializationAnnotation())
              }
            }
          case _ =>
          // Nothing to do
        }

      case fn: FunctionNode =>
        fn.params.paramList.foreach(param => {
          if (!param.isAnnotatedWith(classOf[RequiresMaterializationAnnotation])) {
            if (param.wtype.isDefined) {
              val wType = param.wtype.get
              if (TypeHelper.requiredMaterialize(WeaveType(wType, scope.referenceResolver))) {
                param.annotate(new RequiresMaterializationAnnotation())
              }
            }
          }
        })

      case tpn: TypePatternNode =>
        tpn.pattern match {
          case wtn: WeaveTypeNode =>
            if (!tpn.pattern.isAnnotatedWith(classOf[RequiresMaterializationAnnotation])) {
              val weaveType = WeaveType(wtn, scope.referenceResolver)
              if (TypeHelper.requiredMaterialize(weaveType)) {
                tpn.pattern.annotate(new RequiresMaterializationAnnotation())
              }
            }
          case _ =>
          // Nothing to do
        }

      case _ =>
      // Nothing to do
    }
  }
}

class RequiresMaterializationAnnotation extends AstNodeAnnotation {

  override def name(): String = {
    "RequiresMaterialization"
  }
}
