package org.mule.weave.v2.interpreted.transform

import org.mule.weave.v2.interpreted.node.structure.DocumentNode
import org.mule.weave.v2.interpreted.node.structure.header.directives.ImportDirective
import org.mule.weave.v2.parser
import org.mule.weave.v2.parser.annotation.UntrustedCodeAstNodeAnnotation
import org.mule.weave.v2.parser.ast.header.directives.VersionDirective

trait EngineDocumentTransformations extends EngineImportTransformations {

  def transformDocumentNode(dn: parser.ast.structure.DocumentNode): DocumentNode = {
    val importedModules: Seq[ImportDirective] = transformImportDirectives(dn)
    val maybeVersionDirective: Option[VersionDirective] = dn.header.directives.collectFirst({
      case vd: VersionDirective => vd
    })

    var privileges: Option[Seq[String]] = None
    if (maybeVersionDirective.isDefined) {
      val vd = maybeVersionDirective.get

      // UntrustedCode
      val maybeUntrustedCodeAnnotation = vd.annotation(classOf[UntrustedCodeAstNodeAnnotation])
      if (maybeUntrustedCodeAnnotation.isDefined) {
        privileges = Some(maybeUntrustedCodeAnnotation.get.privileges)
      }
    }
    new DocumentNode(importedModules.toArray, transform(dn.header), transform(dn.root), privileges)
  }
}
