package org.mule.weave.v2.runtime.core.functions.binary

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.BinaryType
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.values.ArrayValue
import org.mule.weave.v2.model.values.StringValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.runtime.core.exception.ReadLinesExecutionException

import java.nio.charset.IllegalCharsetNameException
import java.nio.charset.UnsupportedCharsetException
import scala.io.Source

object ReadLinesFunctionValue extends BinaryFunctionValue {

  override val L = BinaryType

  override val R = StringType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val evaluate = leftValue.evaluate
    try {
      val source = Source.fromInputStream(evaluate, rightValue.evaluate.toString)
      ArrayValue(source.getLines().map(StringValue(_)), this)
    } catch {
      case e: UnsupportedCharsetException => {
        throw new ReadLinesExecutionException(this.location(), "Unsupported Charset: `" + e.getMessage + "`.")
      }
      case e: IllegalCharsetNameException => {
        throw new ReadLinesExecutionException(this.location(), "Illegal Charset: `" + e.getMessage + "`.")
      }
      case e: Exception => {
        throw new ReadLinesExecutionException(this.location(), e.getMessage)
      }
    }
  }
}

