package org.mule.weave.v2.runtime.core.operator.conversion

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.model.structure.schema.SchemaProperty
import org.mule.weave.v2.model.types.AnyType
import org.mule.weave.v2.model.types.ObjectType
import org.mule.weave.v2.model.values.StringValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.model.values.wrappers.AsValue
import org.mule.weave.v2.parser.location._

class MetadataInjectorFunctionValue(override val location: WeaveLocation) extends BinaryFunctionValue {
  override val L = AnyType

  override val R = ObjectType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val properties = rightValue.evaluate.toSeq.map(x =>
      SchemaProperty(StringValue(x._1.evaluate.name), x._2))
    val value = AsValue(leftValue, Some(Schema(properties)), DefaultLocationCapable(location))
    value
  }

}
