package org.mule.weave.v2.interpreted.extension

import org.mule.weave.v2.WeaveScriptingLanguageConfigProperties
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.phase.ModuleParsingPhasesManager
import org.mule.weave.v2.parser.phase.ParsingContext
import org.mule.weave.v2.parser.phase.metrics.ParsingMetricsCollectorListener

/**
  * Factory for ParsingContext
  *
  * @param moduleParserManager parsingManager
  */
class ParsingContextCreator(moduleParserManager: ModuleParsingPhasesManager) {

  def createParsingContext(nameIdentifier: NameIdentifier, attachDocumentation: Boolean): ParsingContext = {
    val parsingContext = ParsingContext(nameIdentifier, moduleParserManager, errorTrace = 0, attachDocumentation = attachDocumentation)
    if (WeaveScriptingLanguageConfigProperties.PARSER_PROFILER) {
      parsingContext.notificationManager.addListener(new ParsingMetricsCollectorListener)
    }
    parsingContext
  }

}

object ParsingContextCreator {
  def apply(moduleParserManager: ModuleParsingPhasesManager): ParsingContextCreator = new ParsingContextCreator(moduleParserManager)
}
