package org.mule.weave.v2.interpreted.marker

import org.mule.weave.v2.interpreted.InterpreterPreCompilerMarker
import org.mule.weave.v2.parser.annotation.AstNodeAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.functions.FunctionNode
import org.mule.weave.v2.parser.ast.functions.OverloadedFunctionNode
import org.mule.weave.v2.parser.phase.ParsingContext
import org.mule.weave.v2.scope.ScopesNavigator
import org.mule.weave.v2.ts.AnyType
import org.mule.weave.v2.ts.ScopeGraphTypeReferenceResolver
import org.mule.weave.v2.ts.TypeHelper
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext

class OverloadedFunctionNotCacheableMarker extends InterpreterPreCompilerMarker {

  override def mark(node: AstNode, scope: ScopesNavigator, context: ParsingContext): Unit = {
    node match {
      case ofn: OverloadedFunctionNode =>
        if (!ofn.isAnnotatedWith(classOf[OverloadedFunctionNotCacheableAnnotation])) {
          val functionParamTypes: Seq[(Seq[WeaveType], Int)] =
            ofn.functionDirectives
              .map(_.literal)
              .collect({
                case fn: FunctionNode => fn
              })
              .map(fn => {
                fn.params.paramList.map(param => {
                  param.wtype.map(pt => WeaveType(pt, new ScopeGraphTypeReferenceResolver(scope))).getOrElse(AnyType())
                })
              })
              .zipWithIndex

          val notCacheable = functionParamTypes.exists(paramTypesWithIndex => {
            functionParamTypes.exists(otherTypes => {
              val actualParams = paramTypesWithIndex._1
              val otherParams = otherTypes._1
              if (otherTypes._2 != paramTypesWithIndex._2 && otherParams.size == actualParams.size) {
                actualParams.zipWithIndex.forall(param => {
                  val paramIndex = param._2
                  val paramType = param._1
                  TypeHelper.canBeSubstitutedWithErasure(paramType, otherParams(paramIndex), new WeaveTypeResolutionContext(null))
                })
              } else {
                false
              }
            })
          })

          if (notCacheable) {
            ofn.annotate(new OverloadedFunctionNotCacheableAnnotation())
          }
        }

      case _ =>
      // Nothing to do
    }

  }
}

class OverloadedFunctionNotCacheableAnnotation extends AstNodeAnnotation {

  override def name(): String = {
    "OverloadedFunctionNotCacheable"
  }
}