package org.mule.weave.v2.interpreted.node

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.ExecutionContext.INIT_METHOD_NAME
import org.mule.weave.v2.interpreted.Frame
import org.mule.weave.v2.interpreted.ModuleContext
import org.mule.weave.v2.interpreted.ValueProviderCapable
import org.mule.weave.v2.interpreted.node.structure.header.VariableTable
import org.mule.weave.v2.interpreted.node.structure.header.directives.Directive
import org.mule.weave.v2.interpreted.node.structure.header.directives.ImportDirective
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.location.Location
import org.mule.weave.v2.parser.location.LocationCapable

class ModuleNode(val importDirectives: Seq[ImportDirective], val directives: Seq[Directive], val variableTable: VariableTable, val moduleTable: VariableTable) extends ExecutionNode {

  var module: Module = _

  override def productElement(n: Int): Any = {
    val function: Seq[Any] = importDirectives ++ directives :+ variableTable :+ moduleTable
    function(n)
  }

  override def productArity: Int = importDirectives.size + directives.size + 2

  def execute(implicit importingContext: ExecutionContext): Module = {
    if (module == null) {
      synchronized {
        val moduleInitFrame = Frame(new Array(variableTable.variables.length), ModuleContext(variableTable, moduleTable, location().resourceName), this, Some(INIT_METHOD_NAME))
        importingContext.runInFrame(moduleInitFrame, {
          importDirectives.foreach(_.execute)
          directives.foreach(_.execute)
        })
        module = new Module(this, moduleInitFrame)
      }
    }
    module
  }
}

class Module(locationCapable: LocationCapable, moduleFrame: Frame) extends ValueProviderCapable with LocationCapable {
  override def getVariable(slot: Int): Value[_] = {
    moduleFrame.variableAt(slot)
  }

  override def location(): Location = locationCapable.location()
}

