package org.mule.weave.v2.interpreted.node.structure.header

import org.mule.weave.v2.interpreted.node.ExecutionNode
import org.mule.weave.v2.interpreted.node.NameSlot
import org.mule.weave.v2.interpreted.node.structure.header.directives.DirectiveOption
import org.mule.weave.v2.interpreted.node.structure.header.directives.FormatExpression

import scala.collection.mutable.ArrayBuffer

/**
  * The external bindings used by the script.
  */
class ExternalBindings() extends ExecutionNode {

  private val externalVars: ArrayBuffer[ExternalBinding] = new ArrayBuffer[ExternalBinding]

  def addVariable(nameSlot: ExternalBinding): Unit = {
    if (!externalVars.exists(_.name.equals(nameSlot.name))) {
      externalVars.+=(nameSlot)
    }
  }

  def variables(): Seq[ExternalBinding] = {
    externalVars
  }

  override def productElement(n: Int): ExternalBinding = externalVars(n)

  override def productArity: Int = externalVars.size
}

case class ExternalBinding(name: NameSlot, format: Option[FormatExpression], options: Option[Seq[DirectiveOption]], streamCapable: Boolean, needsMaterialize: Boolean)
