package org.mule.weave.v2.runtime.core.functions.math

import org.mule.weave.v2.core.exception.InvalidParameterException
import org.mule.weave.v2.core.functions.TernaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.ObjectSeq
import org.mule.weave.v2.model.types.NumberType
import org.mule.weave.v2.model.types.ObjectType
import org.mule.weave.v2.model.values.NumberValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.model.values.ValueProvider
import org.mule.weave.v2.model.values.math

import java.math.MathContext

trait BaseBigDecimalBinaryFunctionValue extends TernaryFunctionValue with BaseBigDecimalFunctionValue {

  def applyOperation(lhs: math.Number, rhs: math.Number, context: MathContext)(implicit ctx: EvaluationContext): math.Number

  override val First: NumberType = NumberType
  override val Second: NumberType = NumberType
  override val Third: ObjectType = configType

  override val thirdDefaultValue: Option[ValueProvider] = contextDefaultValue(this)

  override def doExecute(firstValue: First.V, secondValue: Second.V, thirdValue: Third.V)(implicit ctx: EvaluationContext): Value[_] = {
    val lhs = firstValue.evaluate
    val rhs = secondValue.evaluate
    val context: ObjectSeq = thirdValue.evaluate

    try {
      NumberValue(applyOperation(lhs, rhs, toMathContext(context)), delegate = this)
    } catch {
      case _: java.lang.IllegalArgumentException => throw InvalidParameterException(
        "precision",
        "precision can't be negative",
        thirdValue.location())
    }
  }
}