package org.mule.weave.v2.runtime.core.functions.stringops

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.capabilities.UnknownLocationCapable
import org.mule.weave.v2.model.types.NumberType
import org.mule.weave.v2.model.values.StringValue
import org.mule.weave.v2.model.values.Value

object NumberOrdinalizeFunctionValue extends UnaryFunctionValue {
  override val R = NumberType

  override def doExecute(v: R.V)(implicit executionContext: EvaluationContext): Value[_] = {
    StringValue(Inflector.ordinalize(v.evaluate.toInt), UnknownLocationCapable)
  }
}

object OrdinalizeFunctionValue {
  val value = Seq(NumberOrdinalizeFunctionValue)
}
