package org.mule.weave.v2.runtime.utils

import java.util.concurrent.CountDownLatch

class FutureValue[T] {

  @volatile
  private var value: Option[T] = None
  private val latch: CountDownLatch = new CountDownLatch(1)

  def get: Option[T] = {
    latch.await()
    value
  }

  def set(value: Option[T]): Unit = {
    this.value = value
    this.latch.countDown()
  }

}
