
import fail from dw::Runtime
import dw::Crypto

fun assert(a, b, message: String = ''): Boolean =
  if (a == b)
    true
  else
    using(
      x = fail(
'$message
  "$(a default 'Null')" ($(typeOf(a))) did not match
  "$(b default 'Null')" ($(typeOf(b)))')
    )
      false

fun test(list: Array<Boolean>): Boolean = list reduce ($ and $$) default true
---
test([
  assert(
    Crypto::MD5("asd"),
    "7815696ecbf1c96e6894b779456d330e",
    'String MD5'
  ),
  assert(
    Crypto::SHA1("dsasd"),
    "2fa183839c954e6366c206367c9be5864e4f4a65",
    'String SHA1'
  ),
  assert(
    Crypto::MD5("asd" as Binary),
    "7815696ecbf1c96e6894b779456d330e",
    'Binary MD5'
  ),
  assert(
    Crypto::SHA1("dsasd" as Binary),
    "2fa183839c954e6366c206367c9be5864e4f4a65",
    'Binary SHA1'
  ),
  assert(
    Crypto::HMACWith("xxxxx", "key_re_loca"),
    "ce4031b41fbb41a75806c42d1cc7fdf2c604badf",
    'HMAC SHA1'
   ),
  assert(
    Crypto::HMACWith("xxxxx", "key_re_loca", "HmacSHA256"),
    "5fb8119b9ba6ba355d3ec3ede27b455a41adb3f752e8272a7d72fb7f4383f69f",
    'HMAC SHA256'
  ),
  assert(
    Crypto::HMACWith("xxxxx", "key_re_loca", "HmacSHA512"),
    "9440dcc6a9de1f5c7aae43f225130d07660972efc5f0c7a679ca0590fe6ef8d1e8644ce63d322640b1a9a314016f1d1c108f1ccb371589ca00da06bffea296b9",
    'HMAC SHA512'
  )
])
