package org.mule.weave.v2.runtime.core.functions.types

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.BooleanType
import org.mule.weave.v2.model.types.NumberType
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.types.TypeType
import org.mule.weave.v2.model.values.BooleanValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.location.WeaveLocation

object IsLiteralTypeFunction extends UnaryFunctionValue {
  override val R = TypeType

  override def doExecute(v: R.V)(implicit executionContext: EvaluationContext): Value[_] = {
    v.evaluate.baseType match {
      case stringType: StringType   => if (stringType.value.isDefined) BooleanValue.TRUE_BOOL else BooleanValue.FALSE_BOOL
      case booleanType: BooleanType => if (booleanType.value.isDefined) BooleanValue.TRUE_BOOL else BooleanValue.FALSE_BOOL
      case numberType: NumberType   => if (numberType.value.isDefined) BooleanValue.TRUE_BOOL else BooleanValue.FALSE_BOOL
      case _                        => BooleanValue.FALSE_BOOL
    }
  }
}
