package org.mule.weave.v2.interpreted.node.structure.header.directives

import org.mule.weave.v2.interpreted.node.ExecutionNode
import org.mule.weave.v2.model.values.math.Number

class VersionMajor(v: Number) extends ExecutionNode

class VersionMinor(v: Number) extends ExecutionNode

class VersionDirective(val major: VersionMajor, val minor: VersionMinor) extends Directive with Product2[VersionMajor, VersionMinor] {
  override def _1: VersionMajor = major

  override def _2: VersionMinor = minor
}

object VersionDirective {

  implicit def apply(): VersionDirective = {
    new VersionDirective(0, 1)
  }

  implicit def apply(major: String, minor: String): VersionDirective = {
    new VersionDirective(major.toInt, minor.toInt)
  }

  implicit def apply(major: VersionMajor, minor: VersionMinor): VersionDirective = {
    new VersionDirective(major, minor)
  }
}

object VersionMajor {
  implicit def apply(str: String): VersionMajor = {
    new VersionMajor(Number(str))
  }

  implicit def apply(n: Int): VersionMajor = {
    new VersionMajor(Number(n))
  }
}

object VersionMinor {
  implicit def apply(str: String): VersionMinor = {
    new VersionMinor(Number(str))
  }

  implicit def apply(n: Int): VersionMinor = {
    new VersionMinor(Number(n))
  }
}
