package org.mule.weave.v2.runtime.core.functions.runtime

import org.mule.weave.v2.core.functions.SecureEmptyFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.service.WeaveRuntimePrivilege
import org.mule.weave.v2.model.structure.ObjectSeq
import org.mule.weave.v2.model.values._

object EnvFunctionValue extends SecureEmptyFunctionValue {

  override val requiredPrivilege: WeaveRuntimePrivilege = WeaveRuntimePrivilege.ENVIRONMENT

  override protected def onSecureExecution()(implicit ctx: EvaluationContext): Value[_] = {
    ObjectValue(ObjectSeq(ctx.serviceManager.environmentService.envVars().mapValues(StringValue(_))))
  }
}
