package org.mule.weave.v2.helper

import java.io.File
import java.net.URL
import java.nio.file.Files
import java.nio.file.Paths
import java.util

import spray.json.JsString
import spray.json.PrettyPrinter

import scala.collection.JavaConverters._

trait FileBasedTest extends BaseDataWeaveTest {

  def baseName(x: File): String = {
    if (x.isDirectory) {
      x.getName
    } else {
      val i = x.getName.lastIndexOf(".")
      if (i == -1) {
        x.getName
      } else {
        x.getName.substring(0, i)
      }
    }
  }

  def toJsonStrValue(description: String) = {
    PrettyPrinter(new JsString(description.replaceAll("\\u000a", "")))
  }

  def updateExpectedFileWith(expectedFile: File, newValue: String): Unit = {
    val parts: Array[String] = getClass.getPackage.getName.split("\\.")
    val srcAst: File = new File(new File(expectedFile.getParentFile, s"../../../${"../" * parts.length}src/test/resources/${parts.mkString("/")}"), expectedFile.getName)
    println("WARNING -------------------- Updating ->" + srcAst.getAbsolutePath)
    println(newValue)
    Files.write(Paths.get(srcAst.getPath), newValue.getBytes)
  }

  def scenarios: Seq[(String, File, File)] = {
    val folders: Array[File] = getFoldersForTest(getClass)
    val toSeq: Seq[(String, File, File)] = folders
      .flatMap((folder) => {
        val files = folder.listFiles.sortBy(_.getName).filter(acceptTest)
        files
          .groupBy(baseName)
          .filter(_._2.length == 2)
          .map((entry: (String, Array[File])) => {
            (entry._1, entry._2.filter((f) => isTestFile(f.getName)).head, entry._2.filter((f) => isExpectedFile(f.getName)).head)
          })
      })
      .toSeq
    toSeq.sortBy(_._1)
  }

  def getFoldersForTest(testClass: Class[_]): Array[File] = {
    val url: util.Enumeration[URL] = testClass.getClassLoader.getResources(testClass.getPackage.getName.replaceAll("\\.", "/"))
    val folders = url.asScala.flatMap((url) => {
      if (url.getProtocol.startsWith("file"))
        Some(new File(url.toURI))
      else
        None
    })
    folders.toSeq.toArray
  }

  def ignoreTest(fileName: String): Boolean = false

  def acceptTest(file: File): Boolean = {
    val fileName: String = file.getName
    val testsToRun = Option(System.getProperty("testToRun")) match {
      case Some(x) => x.split(",")
      case None    => Array[String]()
    }
    val accepted: Boolean = {
      testsToRun.isEmpty || testsToRun.exists(baseName(file).equals)
    }
    (isTestFile(fileName) || isExpectedFile(fileName)) && (accepted && !ignoreTest(fileName))
  }

  def isExpectedFile(fileName: String): Boolean = {
    fileName.endsWith(expectedExtension)
  }

  def isTestFile(fileName: String): Boolean = {
    fileName.endsWith(testExtension)
  }

  def testExtension: String = ".dwl"

  def expectedExtension: String = ".json"

}
