package org.mule.weave.v2.module.xmlschema.handler

import org.mule.apache.xerces.impl.dv.xs.XSSimpleTypeDecl
import org.mule.weave.v2.module.xmlschema.utils.XmlConstants
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode

import javax.xml.namespace.QName

object HandlerManager {

  private val handlers = List(new BinaryHandler, new DateHandler, new DateTimeHandler, new NumberHandler, new StringHandler, new TimeHandler, new BooleanHandler)

  def handle(xsTypeDefinition: XSSimpleTypeDecl, defaultValue: Option[String]): WeaveTypeNode = {
    var name: QName = null
    val primitiveType = xsTypeDefinition.getPrimitiveType
    if (primitiveType != null) name = new QName(primitiveType.getNamespace, primitiveType.getName)
    else if (xsTypeDefinition.getName != null) name = new QName(xsTypeDefinition.getNamespace, xsTypeDefinition.getName)
    else name = XmlConstants.XSD_STRING
    for (handler <- handlers) {
      if (handler.handles(name)) return handler.handle(xsTypeDefinition, defaultValue)
    }
    new StringHandler().handle(xsTypeDefinition, defaultValue)
  }
}
