/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.parser.model;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import org.glassfish.jersey.server.model.Parameter;
import org.raml.jaxrs.model.JaxRsEntity;
import org.raml.jaxrs.model.JaxRsQueryParameter;
import org.raml.jaxrs.parser.model.JerseyJaxRsEntity;
import org.raml.jaxrs.parser.model.Utilities;
import org.raml.jaxrs.parser.source.SourceParser;

class JerseyJaxRsQueryParameter
implements JaxRsQueryParameter {
    private final Parameter parameter;
    private final SourceParser sourceParser;

    private JerseyJaxRsQueryParameter(Parameter parameter, SourceParser sourceParser) {
        this.parameter = parameter;
        this.sourceParser = sourceParser;
    }

    static JerseyJaxRsQueryParameter create(Parameter parameter, SourceParser sourceParser) {
        Preconditions.checkNotNull((Object)parameter);
        Preconditions.checkArgument((boolean)Utilities.isQueryParameterPredicate().apply((Object)parameter), (String)"invalid query parameter %s", (Object[])new Object[]{parameter});
        return new JerseyJaxRsQueryParameter(parameter, sourceParser);
    }

    public String getName() {
        return this.parameter.getSourceName();
    }

    public Optional<String> getDefaultValue() {
        return Optional.fromNullable((Object)this.parameter.getDefaultValue());
    }

    public Optional<JaxRsEntity> getEntity() {
        return JerseyJaxRsEntity.create(this.parameter.getType(), this.sourceParser);
    }

    public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationType) {
        return Optional.fromNullable((Object)this.parameter.getAnnotation(annotationType));
    }
}

