/*
 * Decompiled with CFR 0.152.
 */
package amf;

import amf.AmfGraphGenerator;
import amf.AmfGraphParser;
import amf.Oas20Generator;
import amf.Oas20Parser;
import amf.Raml08Generator;
import amf.Raml08Parser;
import amf.Raml10Generator;
import amf.Raml10Parser;
import amf.RamlParser;
import amf.Repl$;
import amf.Repl$Exit$;
import amf.Repl$Generate$;
import amf.Repl$Parse$;
import amf.core.client.Generator;
import amf.core.client.Handler;
import amf.core.client.Parser;
import amf.core.client.StringHandler;
import amf.core.remote.Amf$;
import amf.core.remote.Oas$;
import amf.core.remote.Payload$;
import amf.core.remote.Raml$;
import amf.core.remote.Raml08$;
import amf.core.remote.Raml10$;
import amf.core.remote.Vendor;
import amf.model.document.BaseUnit;
import amf.model.document.Document;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Scanner;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001B\u0001\u0003\u0001\u0015\u0011AAU3qY*\t1!A\u0002b[\u001a\u001c\u0001a\u0005\u0002\u0001\rA\u0011qAC\u0007\u0002\u0011)\t\u0011\"A\u0003tG\u0006d\u0017-\u0003\u0002\f\u0011\t1\u0011I\\=SK\u001aD\u0001\"\u0004\u0001\u0003\u0006\u0004%\tAD\u0001\u0003S:,\u0012a\u0004\t\u0003!Ui\u0011!\u0005\u0006\u0003%M\t!![8\u000b\u0003Q\tAA[1wC&\u0011a#\u0005\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000e\u0003\u0005\u0019\u0001\t\u0005\t\u0015!\u0003\u0010\u0003\rIg\u000e\t\u0005\t5\u0001\u0011)\u0019!C\u00017\u0005\u0019q.\u001e;\u0016\u0003q\u0001\"\u0001E\u000f\n\u0005y\t\"a\u0003)sS:$8\u000b\u001e:fC6D\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u0005_V$\b\u0005C\u0003#\u0001\u0011\u00051%\u0001\u0004=S:LGO\u0010\u000b\u0004I\u0019:\u0003CA\u0013\u0001\u001b\u0005\u0011\u0001\"B\u0007\"\u0001\u0004y\u0001\"\u0002\u000e\"\u0001\u0004a\u0002\"B\u0015\u0001\t\u0013Q\u0013\u0001B5oSR$\u0012a\u000b\t\u0003\u000f1J!!\f\u0005\u0003\tUs\u0017\u000e\u001e\u0005\u0006_\u0001!I\u0001M\u0001\tO\u0016tWM]1uKR\u00191&M\u001e\t\u000bIr\u0003\u0019A\u001a\u0002\tUt\u0017\u000e\u001e\t\u0003iej\u0011!\u000e\u0006\u0003m]\n\u0001\u0002Z8dk6,g\u000e\u001e\u0006\u0003q\t\tQ!\\8eK2L!AO\u001b\u0003\u0011\t\u000b7/Z+oSRDQ\u0001\u0010\u0018A\u0002u\naa]=oi\u0006D\bC\u0001 F\u001d\ty4\t\u0005\u0002A\u00115\t\u0011I\u0003\u0002C\t\u00051AH]8pizJ!\u0001\u0012\u0005\u0002\rA\u0013X\rZ3g\u0013\t1uI\u0001\u0004TiJLgn\u001a\u0006\u0003\t\"AQ!\u0013\u0001\u0005\n)\u000baA]3n_R,G\u0003B\u0016L)ZCQ\u0001\u0014%A\u00025\u000baA^3oI>\u0014\bC\u0001(S\u001b\u0005y%BA%Q\u0015\t\t&!\u0001\u0003d_J,\u0017BA*P\u0005\u00191VM\u001c3pe\")Q\u000b\u0013a\u0001{\u0005\u0019QO\u001d7\t\u000b]C\u0005\u0019\u0001-\u0002\u0011\r\fG\u000e\u001c2bG.\u0004BaB-\\W%\u0011!\f\u0003\u0002\n\rVt7\r^5p]F\u00022a\u0002/_\u0013\ti\u0006B\u0001\u0004PaRLwN\u001c\t\u0003i}K!\u0001Y\u001b\u0003\u0011\u0011{7-^7f]R<QA\u0019\u0001\t\n\r\fQ\u0001U1sg\u0016\u0004\"\u0001Z3\u000e\u0003\u00011QA\u001a\u0001\t\n\u001d\u0014Q\u0001U1sg\u0016\u001c\"!\u001a\u0004\t\u000b\t*G\u0011A5\u0015\u0003\rDQa[3\u0005\u00021\fq!\u001e8baBd\u0017\u0010\u0006\u0002ncB\u0019q\u0001\u00188\u0011\t\u001dyW*P\u0005\u0003a\"\u0011a\u0001V;qY\u0016\u0014\u0004\"\u0002:k\u0001\u0004i\u0014\u0001\u00027j]\u0016DQ\u0001\u001e\u0001\u0005\nU\fa\u0001]1sg\u0016\u0014HC\u0001<}!\t9(0D\u0001y\u0015\tI\b+\u0001\u0004dY&,g\u000e^\u0005\u0003wb\u0014a\u0001U1sg\u0016\u0014\b\"\u0002't\u0001\u0004iu!\u0002@\u0001\u0011\u0013y\u0018\u0001C$f]\u0016\u0014\u0018\r^3\u0011\u0007\u0011\f\tAB\u0004\u0002\u0004\u0001AI!!\u0002\u0003\u0011\u001d+g.\u001a:bi\u0016\u001c2!!\u0001\u0007\u0011\u001d\u0011\u0013\u0011\u0001C\u0001\u0003\u0013!\u0012a \u0005\bW\u0006\u0005A\u0011AA\u0007)\u0011\ty!!\u0005\u0011\u0007\u001daV\b\u0003\u0004s\u0003\u0017\u0001\r!P\u0004\b\u0003+\u0001\u0001\u0012BA\f\u0003\u0011)\u00050\u001b;\u0011\u0007\u0011\fIBB\u0004\u0002\u001c\u0001AI!!\b\u0003\t\u0015C\u0018\u000e^\n\u0004\u000331\u0001b\u0002\u0012\u0002\u001a\u0011\u0005\u0011\u0011\u0005\u000b\u0003\u0003/Aqa[A\r\t\u0003\t)\u0003\u0006\u0003\u0002(\u00055\u0002cA\u0004\u0002*%\u0019\u00111\u0006\u0005\u0003\u000f\t{w\u000e\\3b]\"1!/a\tA\u0002u:q!!\r\u0003\u0011\u0003\t\u0019$\u0001\u0003SKBd\u0007cA\u0013\u00026\u00191\u0011A\u0001E\u0001\u0003o\u00192!!\u000e\u0007\u0011\u001d\u0011\u0013Q\u0007C\u0001\u0003w!\"!a\r\t\u0011\u0005}\u0012Q\u0007C\u0001\u0003\u0003\nQ!\u00199qYf$R\u0001JA\"\u0003\u000bBa!DA\u001f\u0001\u0004y\u0001B\u0002\u000e\u0002>\u0001\u0007A\u0004")
public class Repl {
    private volatile Repl$Parse$ Parse$module;
    private volatile Repl$Generate$ Generate$module;
    private volatile Repl$Exit$ Exit$module;
    private final InputStream in;
    private final PrintStream out;

    public static Repl apply(InputStream inputStream, PrintStream printStream) {
        return Repl$.MODULE$.apply(inputStream, printStream);
    }

    private Repl$Parse$ Parse() {
        if (this.Parse$module == null) {
            this.Parse$lzycompute$1();
        }
        return this.Parse$module;
    }

    private Repl$Generate$ Generate() {
        if (this.Generate$module == null) {
            this.Generate$lzycompute$1();
        }
        return this.Generate$module;
    }

    private Repl$Exit$ Exit() {
        if (this.Exit$module == null) {
            this.Exit$lzycompute$1();
        }
        return this.Exit$module;
    }

    public InputStream in() {
        return this.in;
    }

    public PrintStream out() {
        return this.out;
    }

    private void init() {
        Scanner scanner = new Scanner(this.in());
        ObjectRef<None$> unit = ObjectRef.create(None$.MODULE$);
        while (scanner.hasNextLine()) {
            BoxedUnit boxedUnit;
            Tuple2<Vendor, String> tuple2;
            String string = scanner.nextLine();
            if (this.Exit().unapply(string)) {
                return;
            }
            Option<Tuple2<Vendor, String>> option = this.Parse().unapply(string);
            if (!option.isEmpty() && (tuple2 = option.get()) != null) {
                Vendor vendor = tuple2._1();
                String url = tuple2._2();
                this.remote(vendor, url, (Function1<Option<Document>, BoxedUnit>)(Function1<Option, Object> & Serializable & scala.Serializable)x$1 -> {
                    unit.elem = x$1;
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Option<String> option2 = this.Generate().unapply(string);
            if (!option2.isEmpty()) {
                String syntax = option2.get();
                ((Option)unit.elem).foreach((Function1<Document, Object> & Serializable & scala.Serializable)doc -> {
                    this.generate(doc, syntax);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            this.out().println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"... ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{string})));
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void generate(BaseUnit unit, String syntax) {
        Option option;
        String string = syntax;
        if ("raml".equals(string)) {
            option = new Some<Raml10Generator>(new Raml10Generator());
        } else if ("raml08".equals(string)) {
            option = new Some<Raml08Generator>(new Raml08Generator());
        } else if ("oas".equals(string)) {
            option = new Some<Oas20Generator>(new Oas20Generator());
        } else if ("amf".equals(string)) {
            option = new Some<AmfGraphGenerator>(new AmfGraphGenerator());
        } else {
            this.out().println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported generation for: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{syntax})));
            option = None$.MODULE$;
        }
        Some<Raml10Generator> generator = option;
        generator.foreach((Function1<Generator, Object> & Serializable & scala.Serializable)g -> {
            g.generateString(unit, new StringHandler(this){
                private final /* synthetic */ Repl $outer;

                public void error(Throwable exception) {
                    Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"An error occurred: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{exception})));
                }

                public void success(String generation) {
                    this.$outer.out().print(generation);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return BoxedUnit.UNIT;
        });
    }

    private void remote(Vendor vendor, String url, Function1<Option<Document>, BoxedUnit> callback) {
        this.parser(vendor).parseFile(url, new Handler<BaseUnit>(this, callback){
            private final /* synthetic */ Repl $outer;
            private final Function1 callback$1;

            public void success(BaseUnit unit) {
                this.$outer.out().println("Successfully parsed. Type `:generate raml` or `:generate oas` or `:generate amf`");
                this.callback$1.apply(new Some<Document>(new Document((amf.core.model.document.Document)((Object)unit))));
            }

            public void error(Throwable exception) {
                this.callback$1.apply(None$.MODULE$);
                this.$outer.out().println(exception);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.callback$1 = callback$1;
            }
        });
    }

    private Parser parser(Vendor vendor) {
        Parser parser;
        Vendor vendor2 = vendor;
        if (Raml10$.MODULE$.equals(vendor2)) {
            parser = new Raml10Parser();
        } else if (Raml08$.MODULE$.equals(vendor2)) {
            parser = new Raml08Parser();
        } else if (Raml$.MODULE$.equals(vendor2)) {
            parser = new RamlParser();
        } else if (Oas$.MODULE$.equals(vendor2)) {
            parser = new Oas20Parser();
        } else if (Amf$.MODULE$.equals(vendor2)) {
            parser = new AmfGraphParser();
        } else {
            if (Payload$.MODULE$.equals(vendor2)) {
                throw new Exception("Cannot find a parser for Payload vendor");
            }
            throw new Exception("Cannot find a parser for Unknown vendor");
        }
        return parser;
    }

    private final void Parse$lzycompute$1() {
        Repl repl = this;
        synchronized (repl) {
            if (this.Parse$module == null) {
                this.Parse$module = new Repl$Parse$(null);
            }
        }
    }

    private final void Generate$lzycompute$1() {
        Repl repl = this;
        synchronized (repl) {
            if (this.Generate$module == null) {
                this.Generate$module = new Repl$Generate$(null);
            }
        }
    }

    private final void Exit$lzycompute$1() {
        Repl repl = this;
        synchronized (repl) {
            if (this.Exit$module == null) {
                this.Exit$module = new Repl$Exit$(null);
            }
        }
    }

    public Repl(InputStream in, PrintStream out) {
        this.in = in;
        this.out = out;
        this.init();
    }
}

