/*
 * Decompiled with CFR 0.152.
 */
package amf.core;

import amf.core.AMFSerializer$;
import amf.core.client.GenerationOptions;
import amf.core.model.document.BaseUnit;
import amf.core.model.document.ExternalFragment;
import amf.core.plugins.AMFDocumentPlugin;
import amf.core.plugins.AMFSyntaxPlugin;
import amf.core.registries.AMFPluginsRegistry$;
import amf.core.remote.Platform;
import java.io.Serializable;
import org.yaml.model.YDocument;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001\u000f\ti\u0011)\u0014$TKJL\u0017\r\\5{KJT!a\u0001\u0003\u0002\t\r|'/\u001a\u0006\u0002\u000b\u0005\u0019\u0011-\u001c4\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u0011=\u0001!\u0011!Q\u0001\nA\tA!\u001e8jiB\u0011\u0011CF\u0007\u0002%)\u00111\u0003F\u0001\tI>\u001cW/\\3oi*\u0011QCA\u0001\u0006[>$W\r\\\u0005\u0003/I\u0011\u0001BQ1tKVs\u0017\u000e\u001e\u0005\t3\u0001\u0011\t\u0011)A\u00055\u0005IQ.\u001a3jCRK\b/\u001a\t\u00037\tr!\u0001\b\u0011\u0011\u0005uQQ\"\u0001\u0010\u000b\u0005}1\u0011A\u0002\u001fs_>$h(\u0003\u0002\"\u0015\u00051\u0001K]3eK\u001aL!a\t\u0013\u0003\rM#(/\u001b8h\u0015\t\t#\u0002\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003\u001b\u0003\u00191XM\u001c3pe\"A\u0001\u0006\u0001B\u0001B\u0003%\u0011&A\u0004paRLwN\\:\u0011\u0005)jS\"A\u0016\u000b\u00051\u0012\u0011AB2mS\u0016tG/\u0003\u0002/W\t\tr)\u001a8fe\u0006$\u0018n\u001c8PaRLwN\\:\t\u000bA\u0002A\u0011A\u0019\u0002\rqJg.\u001b;?)\u0015\u0011D'\u000e\u001c8!\t\u0019\u0004!D\u0001\u0003\u0011\u0015yq\u00061\u0001\u0011\u0011\u0015Ir\u00061\u0001\u001b\u0011\u00151s\u00061\u0001\u001b\u0011\u0015As\u00061\u0001*\u0011\u0015I\u0004\u0001\"\u0001;\u0003\u0011i\u0017m[3\u0015\u0003m\u0002\"\u0001\u0010\"\u000e\u0003uR!!\u0006 \u000b\u0005}\u0002\u0015\u0001B=b[2T\u0011!Q\u0001\u0004_J<\u0017BA\">\u0005%IFi\\2v[\u0016tG\u000fC\u0003F\u0001\u0011\u0005a)\u0001\u0007ek6\u0004Hk\\*ue&tw-F\u0001\u001b\u0011\u0015A\u0005\u0001\"\u0001J\u0003)!W/\u001c9U_\u001aKG.\u001a\u000b\u0004\u0015NS\u0006cA&O!6\tAJ\u0003\u0002N\u0015\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005=c%A\u0002$viV\u0014X\r\u0005\u0002\n#&\u0011!K\u0003\u0002\u0005+:LG\u000fC\u0003U\u000f\u0002\u0007Q+\u0001\u0004sK6|G/\u001a\t\u0003-bk\u0011a\u0016\u0006\u0003)\nI!!W,\u0003\u0011Ac\u0017\r\u001e4pe6DQaW$A\u0002i\tA\u0001]1uQ\")Q\f\u0001C\t=\u0006!A-^7q)\u0005Q\u0002\"\u00021\u0001\t#\t\u0017\u0001\u00054j]\u0012$u.\\1j]BcWoZ5o)\u0005\u0011\u0007cA\u0005dK&\u0011AM\u0003\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0019LW\"A4\u000b\u0005!\u0014\u0011a\u00029mk\u001eLgn]\u0005\u0003U\u001e\u0014\u0011#Q'G\t>\u001cW/\\3oiBcWoZ5o\u000f\u0015a'\u0001#\u0001n\u00035\tUJR*fe&\fG.\u001b>feB\u00111G\u001c\u0004\u0006\u0003\tA\ta\\\n\u0003]\"AQ\u0001\r8\u0005\u0002E$\u0012!\u001c\u0005\u0006g:$\t\u0001^\u0001\u0005S:LG\u000fF\u0001Q\u0001")
public class AMFSerializer {
    private final BaseUnit unit;
    private final String mediaType;
    private final String vendor;
    private final GenerationOptions options;

    public static void init() {
        AMFSerializer$.MODULE$.init();
    }

    public YDocument make() {
        YDocument yDocument;
        Option<AMFDocumentPlugin> option = this.findDomainPlugin();
        if (option instanceof Some) {
            YDocument ast;
            Some some = (Some)option;
            AMFDocumentPlugin domainPlugin = (AMFDocumentPlugin)some.value();
            Option<YDocument> option2 = domainPlugin.unparse(this.unit, this.options);
            if (!(option2 instanceof Some)) {
                if (None$.MODULE$.equals(option2)) {
                    throw new Exception(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error unparsing syntax ", " with domain plugin ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.mediaType, domainPlugin.ID()})));
                }
                throw new MatchError(option2);
            }
            Some some2 = (Some)option2;
            yDocument = ast = (YDocument)some2.value();
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new Exception(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot serialize domain model '", "' for detected media type ", " and vendor ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.unit.location(), this.mediaType, this.vendor})));
            }
            throw new MatchError(option);
        }
        YDocument yDocument2 = yDocument;
        return yDocument2;
    }

    public String dumpToString() {
        return this.dump();
    }

    public Future<BoxedUnit> dumpToFile(Platform remote2, String path) {
        return remote2.write(path, this.dump());
    }

    public String dump() {
        String string;
        None$ parsed;
        Option option;
        YDocument ast = this.make();
        Option<AMFSyntaxPlugin> option2 = AMFPluginsRegistry$.MODULE$.syntaxPluginForMediaType(this.mediaType);
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            AMFSyntaxPlugin syntaxPlugin = (AMFSyntaxPlugin)some.value();
            option = syntaxPlugin.unparse(this.mediaType, ast);
        } else if (None$.MODULE$.equals(option2)) {
            Option option3;
            Option<AMFDocumentPlugin> option4 = this.findDomainPlugin();
            if (option4 instanceof Some) {
                Some some = (Some)option4;
                AMFDocumentPlugin domainPlugin = (AMFDocumentPlugin)some.value();
                option3 = domainPlugin.documentSyntaxes().collectFirst(new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 != null) {
                            A1 A12 = A1;
                            object = new Tuple2<A1, Option<AMFSyntaxPlugin>>(A12, AMFPluginsRegistry$.MODULE$.syntaxPluginForMediaType(A12));
                        } else {
                            object = function1.apply(x1);
                        }
                        return object;
                    }

                    public final boolean isDefinedAt(String x1) {
                        String string = x1;
                        boolean bl = string != null;
                        return bl;
                    }
                }).flatMap((Function1<Tuple2, Option> & Serializable & scala.Serializable)x0$1 -> {
                    void var2_9;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String effectiveMediaType = (String)tuple2._1();
                        Option option = (Option)tuple2._2();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            AMFSyntaxPlugin syntaxPlugin = (AMFSyntaxPlugin)some.value();
                            Option<CharSequence> option2 = syntaxPlugin.unparse(effectiveMediaType, ast);
                            return var2_9;
                        }
                    }
                    None$ none$ = None$.MODULE$;
                    return var2_9;
                });
            } else if (None$.MODULE$.equals(option4)) {
                option3 = None$.MODULE$;
            } else {
                throw new MatchError(option4);
            }
            option = option3;
        } else {
            option = None$.MODULE$;
        }
        None$ none$ = parsed = option;
        if (none$ instanceof Some) {
            Some some = (Some)((Object)none$);
            CharSequence doc = (CharSequence)some.value();
            string = ((Object)doc).toString();
        } else if (None$.MODULE$.equals(none$) && this.unit instanceof ExternalFragment) {
            string = ((ExternalFragment)this.unit).encodes().raw();
        } else {
            throw new Exception(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported media type ", " and vendor ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.mediaType, this.vendor})));
        }
        return string;
    }

    public Option<AMFDocumentPlugin> findDomainPlugin() {
        Option option;
        Option option2 = AMFPluginsRegistry$.MODULE$.documentPluginForVendor(this.vendor).find((Function1<AMFDocumentPlugin, Object> & Serializable & scala.Serializable)plugin -> BoxesRunTime.boxToBoolean(AMFSerializer.$anonfun$findDomainPlugin$1(this, plugin)));
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            AMFDocumentPlugin domainPlugin = (AMFDocumentPlugin)some.value();
            option = new Some<AMFDocumentPlugin>(domainPlugin);
        } else if (None$.MODULE$.equals(option2)) {
            option = AMFPluginsRegistry$.MODULE$.documentPluginForMediaType(this.mediaType).find((Function1<AMFDocumentPlugin, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.canUnparse(this.unit)));
        } else {
            throw new MatchError(option2);
        }
        return option;
    }

    public static final /* synthetic */ boolean $anonfun$findDomainPlugin$1(AMFSerializer $this, AMFDocumentPlugin plugin) {
        return plugin.documentSyntaxes().contains($this.mediaType) && plugin.canUnparse($this.unit);
    }

    public AMFSerializer(BaseUnit unit, String mediaType, String vendor, GenerationOptions options) {
        this.unit = unit;
        this.mediaType = mediaType;
        this.vendor = vendor;
        this.options = options;
    }
}

