/*
 * Decompiled with CFR 0.152.
 */
package amf.plugins.document.webapi.validation;

import amf.core.annotations.LexicalInformation;
import amf.core.model.document.BaseUnit;
import amf.core.model.domain.DomainElement;
import amf.core.model.domain.Shape;
import amf.core.remote.Platform;
import amf.core.services.RuntimeValidator$;
import amf.core.validation.AMFValidationReport;
import amf.core.validation.AMFValidationResult;
import amf.core.validation.SeverityLevels$;
import amf.core.vocabulary.Namespace$;
import amf.plugins.document.webapi.validation.ExamplesValidation$;
import amf.plugins.document.webapi.validation.PayloadValidation$;
import amf.plugins.domain.shapes.models.AnyShape;
import amf.plugins.domain.shapes.models.Example;
import amf.plugins.features.validation.ParserSideValidations$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext$Implicits$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0$mcZ$sp;

@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001B\u0001\u0003\u00015\u0011!#\u0012=b[BdWm\u001d,bY&$\u0017\r^5p]*\u00111\u0001B\u0001\u000bm\u0006d\u0017\u000eZ1uS>t'BA\u0003\u0007\u0003\u00199XMY1qS*\u0011q\u0001C\u0001\tI>\u001cW/\\3oi*\u0011\u0011BC\u0001\ba2,x-\u001b8t\u0015\u0005Y\u0011aA1nM\u000e\u00011C\u0001\u0001\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\"AQ\u0003\u0001B\u0001B\u0003%a#A\u0003n_\u0012,G\u000e\u0005\u0002\u001895\t\u0001D\u0003\u0002\b3)\u0011QC\u0007\u0006\u00037)\tAaY8sK&\u0011Q\u0004\u0007\u0002\t\u0005\u0006\u001cX-\u00168ji\"Aq\u0004\u0001B\u0001B\u0003%\u0001%\u0001\u0005qY\u0006$hm\u001c:n!\t\tC%D\u0001#\u0015\t\u0019#$\u0001\u0004sK6|G/Z\u0005\u0003K\t\u0012\u0001\u0002\u00157bi\u001a|'/\u001c\u0005\u0006O\u0001!\t\u0001K\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007%ZC\u0006\u0005\u0002+\u00015\t!\u0001C\u0003\u0016M\u0001\u0007a\u0003C\u0003 M\u0001\u0007\u0001\u0005C\u0003/\u0001\u0011\u0005q&\u0001\u0005wC2LG-\u0019;f)\u0005\u0001\u0004cA\u00195m5\t!G\u0003\u00024!\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005U\u0012$A\u0002$viV\u0014X\rE\u00028\u007f\ts!\u0001O\u001f\u000f\u0005ebT\"\u0001\u001e\u000b\u0005mb\u0011A\u0002\u001fs_>$h(C\u0001\u0012\u0013\tq\u0004#A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0001\u000b%aA*fc*\u0011a\b\u0005\t\u0003\u0007\u0016k\u0011\u0001\u0012\u0006\u0003\u0007iI!A\u0012#\u0003'\u0005keIV1mS\u0012\fG/[8o%\u0016\u001cX\u000f\u001c;\t\u000b!\u0003A\u0011C%\u0002\u0019\u0019Lg\u000eZ#yC6\u0004H.Z:\u0015\u0003)\u0003BaD&N\u001b&\u0011A\n\u0005\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007]zd\nE\u0003\u0010\u001fF;\u0006-\u0003\u0002Q!\t1A+\u001e9mKN\u0002\"AU+\u000e\u0003MS!\u0001V\r\u0002\r\u0011|W.Y5o\u0013\t16KA\u0003TQ\u0006\u0004X\r\u0005\u0002Y=6\t\u0011L\u0003\u0002[7\u00061Qn\u001c3fYNT!\u0001X/\u0002\rMD\u0017\r]3t\u0015\t!\u0006\"\u0003\u0002`3\n9Q\t_1na2,\u0007CA1f\u001d\t\u00117\r\u0005\u0002:!%\u0011A\rE\u0001\u0007!J,G-\u001a4\n\u0005\u0019<'AB*ue&twM\u0003\u0002e!!)\u0011\u000e\u0001C\tU\u0006ya/\u00197jI\u0006$X-\u0012=b[BdW\r\u0006\u0003l_F\u001c\bcA\u00195YB\u0019q\"\u001c\"\n\u00059\u0004\"AB(qi&|g\u000eC\u0003qQ\u0002\u0007\u0011+A\u0003tQ\u0006\u0004X\rC\u0003sQ\u0002\u0007q+A\u0004fq\u0006l\u0007\u000f\\3\t\u000bQD\u0007\u0019\u00011\u0002\u00135,G-[1UsB,\u0007\"\u0002<\u0001\t#9\u0018\u0001G;ogV\u0004\bo\u001c:uK\u0012,\u00050Y7qY\u0016\u0014V\r]8siR\u0019!\t_=\t\u000bI,\b\u0019A,\t\u000bQ,\b\u0019\u00011\t\u000bm\u0004A\u0011\u0003?\u0002/A\f\u0017\u0010\\8bIB\u000b'o]5oO\u0016C8-\u001a9uS>tG\u0003B6~\u0003\u000bAQA >A\u0002}\f\u0011\"\u001a=dKB$\u0018n\u001c8\u0011\u0007]\n\t!C\u0002\u0002\u0004\u0005\u0013\u0011\"\u0012=dKB$\u0018n\u001c8\t\u000bIT\b\u0019A,\t\u000f\u0005%\u0001\u0001\"\u0005\u0002\f\u0005aa/\u00197jI\u0016C\u0018-\u001c9mKR1\u0011QBA\n\u0003+\u00012aDA\b\u0013\r\t\t\u0002\u0005\u0002\b\u0005>|G.Z1o\u0011\u0019\u0011\u0018q\u0001a\u0001/\"1A/a\u0002A\u0002\u0001Dq!!\u0007\u0001\t#\tY\"\u0001\nv]N,\b\u000f]8si\u0016$W\t_1na2,GCBA\u0007\u0003;\ty\u0002\u0003\u0004s\u0003/\u0001\ra\u0016\u0005\u0007i\u0006]\u0001\u0019\u00011\t\rQ\u0004A\u0011CA\u0012)\r\u0001\u0017Q\u0005\u0005\u0007e\u0006\u0005\u0002\u0019A,\t\u000f\u0005%\u0002\u0001\"\u0005\u0002,\u0005qq-^3tg6+G-[1UsB,Gc\u00011\u0002.!1!/a\nA\u0002]Cq!!\r\u0001\t#\t\u0019$A\u0003jgbkG\u000e\u0006\u0003\u0002\u000e\u0005U\u0002bBA\u001c\u0003_\u0001\r\u0001Y\u0001\u0006m\u0006dW/\u001a\u0005\b\u0003w\u0001A\u0011CA\u001f\u0003\u0019I7OS:p]R!\u0011QBA \u0011\u001d\t9$!\u000fA\u0002\u0001<q!a\u0011\u0003\u0011\u0003\t)%\u0001\nFq\u0006l\u0007\u000f\\3t-\u0006d\u0017\u000eZ1uS>t\u0007c\u0001\u0016\u0002H\u00191\u0011A\u0001E\u0001\u0003\u0013\u001a2!a\u0012\u000f\u0011\u001d9\u0013q\tC\u0001\u0003\u001b\"\"!!\u0012\t\u0011\u0005E\u0013q\tC\u0001\u0003'\nQ!\u00199qYf$R!KA+\u0003/Ba!FA(\u0001\u00041\u0002BB\u0010\u0002P\u0001\u0007\u0001\u0005")
public class ExamplesValidation {
    private final BaseUnit model;
    private final Platform platform;

    public static ExamplesValidation apply(BaseUnit baseUnit, Platform platform2) {
        return ExamplesValidation$.MODULE$.apply(baseUnit, platform2);
    }

    public Future<Seq<AMFValidationResult>> validate() {
        Tuple2<Seq<Tuple3<Shape, Example, String>>, Seq<Tuple3<Shape, Example, String>>> tuple2 = this.findExamples();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq<Tuple3<Shape, Example, String>> supportedExamples = tuple2._1();
        Seq<Tuple3<Shape, Example, String>> unsupportedExamples = tuple2._2();
        Tuple2<Seq<Tuple3<Shape, Example, String>>, Seq<Tuple3<Shape, Example, String>>> tuple22 = new Tuple2<Seq<Tuple3<Shape, Example, String>>, Seq<Tuple3<Shape, Example, String>>>(supportedExamples, unsupportedExamples);
        Tuple2<Seq<Tuple3<Shape, Example, String>>, Seq<Tuple3<Shape, Example, String>>> tuple23 = tuple22;
        Seq<Tuple3<Shape, Example, String>> supportedExamples2 = tuple23._1();
        Seq<Tuple3<Shape, Example, String>> unsupportedExamples2 = tuple23._2();
        Seq unsupportedExamplesValidations = unsupportedExamples2.map((Function1<Tuple3, AMFValidationResult> & Serializable & scala.Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            Example example = (Example)tuple3._2();
            String mediaType = (String)tuple3._3();
            AMFValidationResult aMFValidationResult = this.unsupportedExampleReport(example, mediaType);
            return aMFValidationResult;
        }, Seq$.MODULE$.canBuildFrom());
        Seq listSupportedResults = supportedExamples2.map((Function1<Tuple3, Future> & Serializable & scala.Serializable)x0$2 -> {
            Tuple3 tuple3 = x0$2;
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            Shape shape = (Shape)tuple3._1();
            Example example = (Example)tuple3._2();
            String mediaType = (String)tuple3._3();
            Future<Option<AMFValidationResult>> future = this.validateExample(shape, example, mediaType);
            return future;
        }, Seq$.MODULE$.canBuildFrom());
        Future futureResult = Future$.MODULE$.sequence(listSupportedResults, Seq$.MODULE$.canBuildFrom(), ExecutionContext$Implicits$.MODULE$.global());
        return futureResult.map((Function1<Seq, Seq> & Serializable & scala.Serializable)supportedResults -> ((TraversableLike)((TraversableLike)supportedResults.filter((Function1<Option, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(x$2.isDefined()))).map((Function1<Option, AMFValidationResult> & Serializable & scala.Serializable)x$3 -> (AMFValidationResult)x$3.get(), Seq$.MODULE$.canBuildFrom())).$plus$plus(unsupportedExamplesValidations, Seq$.MODULE$.canBuildFrom()), ExecutionContext$Implicits$.MODULE$.global());
    }

    public Tuple2<Seq<Tuple3<Shape, Example, String>>, Seq<Tuple3<Shape, Example, String>>> findExamples() {
        Seq allExamples = this.model.findByType(Namespace$.MODULE$.Shapes().$plus("Shape").iri(), this.model.findByType$default$2()).flatMap((Function1<DomainElement, Seq> & Serializable & scala.Serializable)x0$3 -> {
            Seq<Nothing$> seq2;
            DomainElement domainElement = x0$3;
            if (domainElement instanceof AnyShape) {
                AnyShape anyShape = (AnyShape)domainElement;
                seq2 = anyShape.examples().map((Function1<Example, Tuple3> & Serializable & scala.Serializable)example -> new Tuple3<AnyShape, Example, String>(anyShape, (Example)example, this.mediaType((Example)example)), Seq$.MODULE$.canBuildFrom());
            } else {
                seq2 = Nil$.MODULE$;
            }
            return seq2;
        }, Seq$.MODULE$.canBuildFrom());
        Seq supportedExamples = (Seq)allExamples.filter((Function1<Tuple3, Object> & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean(ExamplesValidation.$anonfun$findExamples$3(this, x0$4)));
        Seq unsupportedExamples = (Seq)allExamples.filter((Function1<Tuple3, Object> & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean(ExamplesValidation.$anonfun$findExamples$4(this, x0$5)));
        return new Tuple2<Seq<Tuple3<Shape, Example, String>>, Seq<Tuple3<Shape, Example, String>>>(supportedExamples, unsupportedExamples);
    }

    public Future<Option<AMFValidationResult>> validateExample(Shape shape, Example example, String mediaType) {
        Future<Option<AMFValidationResult>> future;
        RuntimeValidator$.MODULE$.reset();
        try {
            future = PayloadValidation$.MODULE$.apply(this.platform, shape).validate(example.structuredValue()).map((Function1<AMFValidationReport, Option> & Serializable & scala.Serializable)report -> report.conforms() ? None$.MODULE$ : new Some<AMFValidationResult>(new AMFValidationResult(report.toString(), SeverityLevels$.MODULE$.VIOLATION(), example.id(), new Some<String>(Namespace$.MODULE$.Document().$plus("value").iri()), ParserSideValidations$.MODULE$.ExampleValidationErrorSpecification().id(), example.annotations().find(LexicalInformation.class), example)), ExecutionContext$Implicits$.MODULE$.global());
        }
        catch (Exception e2) {
            future = this.payloadParsingException(e2, example);
        }
        return future;
    }

    public AMFValidationResult unsupportedExampleReport(Example example, String mediaType) {
        return new AMFValidationResult("Cannot validate example with unsupported media type " + mediaType, SeverityLevels$.MODULE$.WARNING(), example.id(), new Some<String>(Namespace$.MODULE$.Document().$plus("value").iri()), ParserSideValidations$.MODULE$.UnsupportedExampleMediaTypeErrorSpecification().id(), example.annotations().find(LexicalInformation.class), example);
    }

    public Future<Option<AMFValidationResult>> payloadParsingException(Exception exception, Example example) {
        Promise<Some<AMFValidationResult>> promise = Promise$.MODULE$.apply();
        AMFValidationResult validationResult = new AMFValidationResult("Payload parsing validation error: " + exception.getMessage(), SeverityLevels$.MODULE$.VIOLATION(), example.id(), None$.MODULE$, ParserSideValidations$.MODULE$.ExampleValidationErrorSpecification().id(), example.annotations().find(LexicalInformation.class), example);
        promise.success(new Some<AMFValidationResult>(validationResult));
        return promise.future();
    }

    public boolean validExample(Example example, String mediaType) {
        return Option$.MODULE$.apply(example.value()).isDefined() && BoxesRunTime.unboxToBoolean(Option$.MODULE$.apply(BoxesRunTime.boxToBoolean(example.strict())).getOrElse((JFunction0$mcZ$sp & scala.Serializable)() -> false)) && (mediaType.indexOf("json") > -1 || mediaType.indexOf("yaml") > -1);
    }

    public boolean unsupportedExample(Example example, String mediaType) {
        return BoxesRunTime.unboxToBoolean(Option$.MODULE$.apply(BoxesRunTime.boxToBoolean(example.strict())).getOrElse((JFunction0$mcZ$sp & scala.Serializable)() -> false)) && !this.validExample(example, mediaType);
    }

    public String mediaType(Example example) {
        String string;
        Option<String> option = Option$.MODULE$.apply(example.mediaType());
        if (option instanceof Some) {
            String mediaType;
            Some some = (Some)option;
            string = mediaType = (String)some.value();
        } else if (None$.MODULE$.equals(option)) {
            string = this.guessMediaType(example);
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    public String guessMediaType(Example example) {
        String string;
        Option<String> option = Option$.MODULE$.apply(example.value());
        if (option instanceof Some) {
            Some some = (Some)option;
            String value = (String)some.value();
            string = this.isXml(value) ? "application/xml" : (this.isJson(value) ? "application/json" : "text/vnd.yaml");
        } else if (None$.MODULE$.equals(option)) {
            string = "*/*";
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    public boolean isXml(String value) {
        return value.startsWith("<");
    }

    public boolean isJson(String value) {
        return value.startsWith("{") || value.startsWith("[");
    }

    public static final /* synthetic */ boolean $anonfun$findExamples$3(ExamplesValidation $this, Tuple3 x0$4) {
        Tuple3 tuple3 = x0$4;
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Example example = (Example)tuple3._2();
        String mediaType = (String)tuple3._3();
        boolean bl = $this.validExample(example, mediaType);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$findExamples$4(ExamplesValidation $this, Tuple3 x0$5) {
        Tuple3 tuple3 = x0$5;
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Example example = (Example)tuple3._2();
        String mediaType = (String)tuple3._3();
        boolean bl = $this.unsupportedExample(example, mediaType);
        return bl;
    }

    public ExamplesValidation(BaseUnit model, Platform platform2) {
        this.model = model;
        this.platform = platform2;
    }
}

