/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class Java7Support {
    private static final boolean IS_JAVA7;
    private static Method isSymbolicLink;
    private static Method delete;
    private static Method toPath;
    private static Method exists;
    private static Method toFile;
    private static Method readSymlink;
    private static Method createSymlink;
    private static Object emptyLinkOpts;
    private static Object emptyFileAttributes;

    Java7Support() {
    }

    public static boolean isSymLink(File file) {
        try {
            Object path = toPath.invoke((Object)file, new Object[0]);
            Boolean result2 = (Boolean)isSymbolicLink.invoke(null, path);
            return result2;
        }
        catch (IllegalAccessException e2) {
            throw new RuntimeException(e2);
        }
        catch (InvocationTargetException e3) {
            throw new RuntimeException(e3);
        }
    }

    public static File readSymbolicLink(File symlink) throws IOException {
        try {
            Object path = toPath.invoke((Object)symlink, new Object[0]);
            Object resultPath = readSymlink.invoke(null, path);
            return (File)toFile.invoke(resultPath, new Object[0]);
        }
        catch (IllegalAccessException e2) {
            throw new RuntimeException(e2);
        }
        catch (InvocationTargetException e3) {
            throw new RuntimeException(e3);
        }
    }

    private static boolean exists(File file) throws IOException {
        try {
            Object path = toPath.invoke((Object)file, new Object[0]);
            Boolean result2 = (Boolean)exists.invoke(null, path, emptyLinkOpts);
            return result2;
        }
        catch (IllegalAccessException e2) {
            throw new RuntimeException(e2);
        }
        catch (InvocationTargetException e3) {
            throw (RuntimeException)e3.getTargetException();
        }
    }

    public static File createSymbolicLink(File symlink, File target) throws IOException {
        try {
            if (!Java7Support.exists(symlink)) {
                Object link = toPath.invoke((Object)symlink, new Object[0]);
                Object path = createSymlink.invoke(null, link, toPath.invoke((Object)target, new Object[0]), emptyFileAttributes);
                return (File)toFile.invoke(path, new Object[0]);
            }
            return symlink;
        }
        catch (IllegalAccessException e2) {
            throw new RuntimeException(e2);
        }
        catch (InvocationTargetException e3) {
            Throwable targetException = e3.getTargetException();
            throw (IOException)targetException;
        }
    }

    public static void delete(File file) throws IOException {
        try {
            Object path = toPath.invoke((Object)file, new Object[0]);
            delete.invoke(null, path);
        }
        catch (IllegalAccessException e2) {
            throw new RuntimeException(e2);
        }
        catch (InvocationTargetException e3) {
            throw (IOException)e3.getTargetException();
        }
    }

    public static boolean isAtLeastJava7() {
        return IS_JAVA7;
    }

    static {
        boolean isJava7x = true;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> files2 = cl.loadClass("java.nio.file.Files");
            Class<?> path = cl.loadClass("java.nio.file.Path");
            Class<?> fa = cl.loadClass("java.nio.file.attribute.FileAttribute");
            Class<?> linkOption = cl.loadClass("java.nio.file.LinkOption");
            isSymbolicLink = files2.getMethod("isSymbolicLink", path);
            delete = files2.getMethod("delete", path);
            readSymlink = files2.getMethod("readSymbolicLink", path);
            emptyFileAttributes = Array.newInstance(fa, 0);
            createSymlink = files2.getMethod("createSymbolicLink", path, path, emptyFileAttributes.getClass());
            emptyLinkOpts = Array.newInstance(linkOption, 0);
            exists = files2.getMethod("exists", path, emptyLinkOpts.getClass());
            toPath = File.class.getMethod("toPath", new Class[0]);
            toFile = path.getMethod("toFile", new Class[0]);
        }
        catch (ClassNotFoundException e2) {
            isJava7x = false;
        }
        catch (NoSuchMethodException e3) {
            isJava7x = false;
        }
        IS_JAVA7 = isJava7x;
    }
}

