/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.assembler.assemblers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.AssemblerHelp;
import org.apache.jena.assembler.JA;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.assembler.exceptions.AmbiguousSpecificTypeException;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.assembler.exceptions.NoImplementationException;
import org.apache.jena.assembler.exceptions.NoSpecificTypeException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDFS;

public abstract class AssemblerGroup
extends AssemblerBase
implements Assembler {
    public abstract AssemblerGroup implementWith(Resource var1, Assembler var2);

    public abstract Assembler assemblerFor(Resource var1);

    @Override
    public Model openModel(Resource resource) {
        return (Model)this.open(resource);
    }

    public static AssemblerGroup create() {
        return new ExpandingAssemblerGroup();
    }

    public AssemblerGroup copy() {
        ExpandingAssemblerGroup result2 = (ExpandingAssemblerGroup)AssemblerGroup.create();
        result2.internal.mappings.putAll(((ExpandingAssemblerGroup)this).internal.mappings);
        return result2;
    }

    static class PlainAssemblerGroup
    extends AssemblerGroup {
        Map<Resource, Assembler> mappings = new HashMap<Resource, Assembler>();

        PlainAssemblerGroup() {
        }

        @Override
        public Object open(Assembler a, Resource root2, Mode mode) {
            Set<Resource> types = AssemblerHelp.findSpecificTypes(root2, JA.Object);
            if (types.size() == 0) {
                boolean noSuchSubject;
                boolean bl = noSuchSubject = !root2.listProperties().hasNext();
                if (noSuchSubject) {
                    String s = root2.isURIResource() ? "<" + root2.getURI() + ">" : (root2.isAnon() ? "_:" + root2.getId() : String.valueOf(root2));
                    throw new AssemblerException(root2, "Can't find " + s + " as a subject");
                }
                throw new NoSpecificTypeException(root2);
            }
            if (types.size() > 1) {
                throw new AmbiguousSpecificTypeException(root2, new ArrayList<Resource>(types));
            }
            return this.openBySpecificType(a, root2, mode, types.iterator().next());
        }

        private Object openBySpecificType(Assembler a, Resource root2, Mode mode, Resource type) {
            Assembler toUse = this.assemblerFor(type);
            Class<?> aClass = toUse == null ? null : toUse.getClass();
            Frame frame = new Frame(root2, type, aClass);
            try {
                if (toUse == null) {
                    throw new NoImplementationException(this, root2, type);
                }
                return toUse.open(a, root2, mode);
            }
            catch (AssemblerException e2) {
                throw e2.pushDoing(frame);
            }
            catch (Exception e3) {
                AssemblerException x = new AssemblerException(root2, "caught: " + e3.getMessage(), e3);
                throw x.pushDoing(frame);
            }
        }

        @Override
        public AssemblerGroup implementWith(Resource type, Assembler a) {
            this.mappings.put(type, a);
            return this;
        }

        @Override
        public Assembler assemblerFor(Resource type) {
            return this.mappings.get(type);
        }
    }

    public static class ExpandingAssemblerGroup
    extends AssemblerGroup {
        PlainAssemblerGroup internal = new PlainAssemblerGroup();
        Model implementTypes = ModelFactory.createDefaultModel();

        @Override
        public Object open(Assembler a, Resource suppliedRoot, Mode mode) {
            Resource root2 = AssemblerHelp.withFullModel(suppliedRoot);
            this.loadClasses(root2.getModel());
            root2.getModel().add(this.implementTypes);
            return this.internal.open(a, root2, mode);
        }

        public void loadClasses(Model model) {
            AssemblerHelp.loadArbitraryClasses(this, model);
            AssemblerHelp.loadAssemblerClasses(this, model);
        }

        @Override
        public AssemblerGroup implementWith(Resource type, Assembler a) {
            this.implementTypes.add(type, RDFS.Init.subClassOf(), JA.Object);
            this.internal.implementWith(type, a);
            return this;
        }

        @Override
        public Assembler assemblerFor(Resource type) {
            return this.internal.assemblerFor(type);
        }

        public Set<Resource> implementsTypes() {
            return this.implementTypes.listStatements().mapWith(Statement::getSubject).toSet();
        }
    }

    public static class Frame {
        public final Resource root;
        public final Resource type;
        public final Class<? extends Assembler> assembler;

        public Frame(Resource root2, Resource type, Class<? extends Assembler> assembler) {
            this.root = root2;
            this.type = type;
            this.assembler = assembler;
        }

        public boolean equals(Object other) {
            return other instanceof Frame && this.same((Frame)other);
        }

        protected boolean same(Frame other) {
            return this.root.equals(other.root) && this.type.equals(other.type) && this.assembler.equals(other.assembler);
        }

        public String toString() {
            return "root: " + this.root + " with type: " + this.type + " assembler class: " + this.assembler;
        }
    }
}

