/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.assembler.assemblers;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.JA;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.ModelAssembler;
import org.apache.jena.rdf.model.InfModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ReasonerFactory;
import org.apache.jena.reasoner.rulesys.GenericRuleReasonerFactory;

public class InfModelAssembler
extends ModelAssembler {
    @Override
    protected Model openEmptyModel(Assembler a, Resource root2, Mode mode) {
        this.checkType(root2, JA.InfModel);
        Model base = this.getBase(a, root2, mode);
        Reasoner reasoner = this.getReasoner(a, root2);
        InfModel result2 = ModelFactory.createInfModel(reasoner, base);
        return result2;
    }

    protected Model getBase(Assembler a, Resource root2, Mode mode) {
        Resource base = InfModelAssembler.getUniqueResource(root2, JA.baseModel);
        return base == null ? ModelFactory.createDefaultModel() : a.openModel(base, mode);
    }

    protected Reasoner getReasoner(Assembler a, Resource root2) {
        return this.getReasonerFactory(a, root2).create(root2);
    }

    protected ReasonerFactory getReasonerFactory(Assembler a, Resource root2) {
        Resource factory = InfModelAssembler.getUniqueResource(root2, JA.reasoner);
        return factory == null ? GenericRuleReasonerFactory.theInstance() : (ReasonerFactory)a.open(factory);
    }
}

