/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.assembler.assemblers;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.JA;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.InfModelAssembler;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.StmtIterator;

public class OntModelAssembler
extends InfModelAssembler
implements Assembler {
    @Override
    public Model openEmptyModel(Assembler a, Resource root2, Mode mode) {
        this.checkType(root2, JA.OntModel);
        Model baseModel = this.getBase(a, root2, mode);
        OntModelSpec oms = this.getOntModelSpec(a, root2);
        OntModel om = ModelFactory.createOntologyModel(oms, baseModel);
        this.addSubModels(a, root2, mode, om);
        return om;
    }

    private void addSubModels(Assembler a, Resource root2, Mode mode, OntModel om) {
        List<Model> subModels = this.getSubModels(a, root2, mode);
        for (Model subModel : subModels) {
            om.addSubModel(subModel);
        }
    }

    private List<Model> getSubModels(Assembler a, Resource root2, Mode mode) {
        ArrayList<Model> result2 = new ArrayList<Model>();
        StmtIterator it = root2.listProperties(JA.subModel);
        while (it.hasNext()) {
            result2.add(a.openModel(it.nextStatement().getResource(), mode));
        }
        return result2;
    }

    static final OntModelSpec defaultSpec() {
        return OntModelSpec.OWL_MEM_RDFS_INF;
    }

    protected OntModelSpec getOntModelSpec(Assembler a, Resource root2) {
        Resource r = OntModelAssembler.getUniqueResource(root2, JA.ontModelSpec);
        return r == null ? OntModelAssembler.defaultSpec() : (OntModelSpec)a.open(r);
    }
}

