/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.assembler.exceptions;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.rdf.model.Resource;

public class AmbiguousSpecificTypeException
extends AssemblerException {
    protected final List<Resource> types;

    public AmbiguousSpecificTypeException(Resource root2, ArrayList<Resource> types) {
        super(root2, AmbiguousSpecificTypeException.makeMessage(root2, types));
        this.types = types;
    }

    private static String makeMessage(Resource root2, List<Resource> types) {
        return "cannot find a most specific type for " + AmbiguousSpecificTypeException.nice(root2) + ", which has as possibilities:" + AmbiguousSpecificTypeException.nice(types) + ".";
    }

    private static String nice(List<Resource> types) {
        StringBuilder result2 = new StringBuilder();
        for (Resource type : types) {
            result2.append(" ").append(AmbiguousSpecificTypeException.nice(type));
        }
        return result2.toString();
    }

    public List<Resource> getTypes() {
        return this.types;
    }
}

