/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.iri.impl;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.iri.ViolationCodes;
import org.apache.jena.iri.impl.ErrorAction;
import org.apache.jena.iri.impl.GroupAction;
import org.apache.jena.iri.impl.HostAction;

public class ComponentPatternParser
implements ViolationCodes {
    static String separators = "([(](?![?]))|([(][?])|([)])|(\\[)|(\\])|([@][{])|([}]|[a-z]-[a-z])";
    static final int OPEN_PAREN = 1;
    static final int OPEN_NON_CAPTURING_PAREN = 2;
    static final int CLOSE_PAREN = 3;
    static final int OPEN_SQ = 4;
    static final int CLOSE_SQ = 5;
    static final int OPEN_VAR = 6;
    static final int CLOSE_BRACE = 7;
    static final int LOWER_CASE_RANGE = 8;
    static final int OTHER = -1;
    static final Pattern keyword = Pattern.compile(separators);
    final String[] split;
    final int[] classify;
    int field;
    int groupCount;
    final StringBuffer rslt = new StringBuffer();
    int shouldLowerCase;
    int mustLowerCase;
    int hostNames;
    final Pattern pattern;
    static final String[] emptyStringArray = new String[0];

    private static String[] mySplit(String p) {
        Matcher m = keyword.matcher(p);
        ArrayList<String> rslt = new ArrayList<String>();
        int pos = 0;
        while (m.find()) {
            if (m.start() > pos || pos == 0) {
                rslt.add(p.substring(pos, m.start()));
            }
            rslt.add(p.substring(m.start(), m.end()));
            pos = m.end();
        }
        if (pos < p.length()) {
            rslt.add(p.substring(pos));
        }
        return rslt.toArray(emptyStringArray);
    }

    public ComponentPatternParser(String p) {
        this.split = ComponentPatternParser.mySplit(p);
        this.field = 0;
        this.classify = new int[this.split.length];
        for (int i = 0; i < this.split.length; ++i) {
            this.classify[i] = this.classify(this.split[i]);
        }
        while (this.field < this.split.length) {
            this.next();
        }
        this.pattern = Pattern.compile(this.rslt.toString());
    }

    public Pattern get() {
        return this.pattern;
    }

    GroupAction[] actions() {
        int gCount = this.pattern.matcher("").groupCount() + 1;
        GroupAction[] result2 = new GroupAction[gCount];
        for (int i = 1; i < gCount; ++i) {
            int g = 1 << i;
            result2[i] = (this.mustLowerCase & g) != 0 ? new ErrorAction(59) : ((this.shouldLowerCase & g) != 0 ? new ErrorAction(60) : ((this.hostNames & g) != 0 ? new HostAction(i) : GroupAction.NoAction));
        }
        return result2;
    }

    private int classify(String string) {
        Matcher m = keyword.matcher(string);
        if (!m.matches()) {
            return -1;
        }
        for (int i = 1; i <= m.groupCount(); ++i) {
            if (m.start(i) == -1) continue;
            return i;
        }
        throw new IllegalStateException("IRI code internal error: no group matched.");
    }

    private void untilCloseSq() {
        while (this.classify[this.field - 1] != 5) {
            if (this.field >= this.split.length) {
                throw new IllegalArgumentException("Internal IRI code error. Did not find CLOSE_SQ in until().");
            }
            this.add();
        }
    }

    private void next() {
        switch (this.classify[this.field]) {
            case 5: {
                throw new IllegalArgumentException("Found unexpected ], either pattern syntax error, or limitation of IRI code.");
            }
            case 4: {
                this.add();
                this.untilCloseSq();
                break;
            }
            case 6: {
                ++this.field;
                this.rslt.append("(");
                ++this.groupCount;
                if (this.split[this.field].equals("host")) {
                    this.addHost();
                    break;
                }
                if (this.split[this.field].equals("shouldLowerCase")) {
                    this.shouldLowerCase |= 1 << this.groupCount;
                } else if (this.split[this.field].equals("mustLowerCase")) {
                    this.mustLowerCase |= 1 << this.groupCount;
                } else {
                    throw new IllegalArgumentException("No macro: " + this.split[this.field]);
                }
                this.addLowerCase();
                break;
            }
            case 1: {
                ++this.groupCount;
            }
            case -1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                this.add();
                return;
            }
            default: {
                throw new IllegalStateException("IRI code internal error.");
            }
        }
    }

    private void addLowerCase() {
        int sqCount = 0;
        ++this.field;
        if (this.classify[this.field] != 1) {
            throw new IllegalArgumentException(this.split[this.field - 1] + " macro syntax error");
        }
        ++this.field;
        this.rslt.append("?:(?:");
        StringBuffer caseInsensitiveEx = new StringBuffer();
        while (this.classify[this.field - 1] != 3 || sqCount > 0) {
            if (this.field >= this.split.length) {
                throw new IllegalArgumentException("Internal IRI code error. Did not find CLOSE_PAREN in addLowerCase().");
            }
            switch (this.classify[this.field]) {
                case 4: {
                    ++sqCount;
                    caseInsensitiveEx.append('[');
                    break;
                }
                case 5: {
                    --sqCount;
                    caseInsensitiveEx.append(']');
                    break;
                }
                case 8: {
                    if (sqCount == 0) {
                        this.makeCaseInsensitive(caseInsensitiveEx);
                        break;
                    }
                    caseInsensitiveEx.append(this.split[this.field]);
                    caseInsensitiveEx.append((char)(this.split[this.field].charAt(0) - 97 + 65));
                    caseInsensitiveEx.append('-');
                    caseInsensitiveEx.append((char)(this.split[this.field].charAt(2) - 97 + 65));
                    break;
                }
                case 1: {
                    if (sqCount == 0) {
                        throw new IllegalStateException("IRI code internal error: capturing group not supported inside lowercase.");
                    }
                }
                case 2: 
                case 3: 
                case 7: {
                    caseInsensitiveEx.append(this.split[this.field]);
                    break;
                }
                case -1: {
                    this.makeCaseInsensitive(caseInsensitiveEx);
                    break;
                }
                default: {
                    throw new IllegalStateException("IRI code internal error.");
                }
            }
            this.add();
        }
        if (this.classify[this.field] != 7) {
            throw new IllegalArgumentException("case macro syntax error");
        }
        ++this.field;
        this.rslt.append("|(");
        this.rslt.append(caseInsensitiveEx);
        this.rslt.append(")");
    }

    private void makeCaseInsensitive(StringBuffer caseInsensitiveEx) {
        for (int i = 0; i < this.split[this.field].length(); ++i) {
            char c = this.split[this.field].charAt(i);
            if (c < 'a' || c > 'z') continue;
            caseInsensitiveEx.append('[');
            caseInsensitiveEx.append(c);
            caseInsensitiveEx.append((char)(c - 97 + 65));
            caseInsensitiveEx.append(']');
        }
    }

    private void addHost() {
        this.hostNames |= 1 << this.groupCount;
        ++this.field;
        if (this.classify[this.field] != 7) {
            throw new IllegalArgumentException("host macro syntax error");
        }
        this.rslt.append("[^\\[\\]:/?#@!$&'()*+,;=]*|\\[[^\\[\\]/?#@!$&'()*+,;=]*\\])");
        ++this.field;
    }

    private void add() {
        this.rslt.append(this.split[this.field]);
        ++this.field;
    }

    public String toString() {
        return this.pattern.pattern();
    }
}

