/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem;

import org.apache.jena.graph.GraphEvents;
import org.apache.jena.graph.GraphStatisticsHandler;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.TripleStore;
import org.apache.jena.mem.GraphMemBase;
import org.apache.jena.mem.GraphTripleStoreMem;
import org.apache.jena.mem.NodeToTriplesMapMem;
import org.apache.jena.mem.TripleBunch;
import org.apache.jena.util.iterator.ExtendedIterator;

public class GraphMem
extends GraphMemBase {
    @Override
    protected TripleStore createTripleStore() {
        return new GraphTripleStoreMem(this);
    }

    @Override
    protected void destroy() {
        this.store.close();
    }

    @Override
    public void performAdd(Triple t) {
        this.store.add(t);
    }

    @Override
    public void performDelete(Triple t) {
        this.store.delete(t);
    }

    @Override
    public int graphBaseSize() {
        return this.store.size();
    }

    @Override
    protected GraphStatisticsHandler createStatisticsHandler() {
        return new GraphMemStatisticsHandler((GraphTripleStoreMem)this.store);
    }

    @Override
    public ExtendedIterator<Triple> graphBaseFind(Triple m) {
        return this.store.find(m);
    }

    @Override
    public boolean graphBaseContains(Triple t) {
        return t.isConcrete() ? this.store.contains(t) : super.graphBaseContains(t);
    }

    @Override
    public void clear() {
        this.clearStore();
        this.getEventManager().notifyEvent(this, GraphEvents.removeAll);
    }

    public void clearStore() {
        this.store.clear();
    }

    protected static class GraphMemStatisticsHandler
    implements GraphStatisticsHandler {
        protected final GraphTripleStoreMem store;

        public GraphMemStatisticsHandler(GraphTripleStoreMem store) {
            this.store = store;
        }

        @Override
        public long getStatistic(Node S, Node P2, Node O) {
            int concrete = (S.isConcrete() ? 1 : 0) + (P2.isConcrete() ? 2 : 0) + (O.isConcrete() ? 4 : 0);
            switch (concrete) {
                case 0: {
                    return this.store.size();
                }
                case 1: {
                    return this.countInMap(S, this.store.getSubjects());
                }
                case 3: {
                    return this.countsInMap(S, this.store.getSubjects(), P2, this.store.getPredicates());
                }
                case 5: {
                    return this.countsInMap(S, this.store.getSubjects(), O, this.store.getObjects());
                }
                case 2: {
                    return this.countInMap(P2, this.store.getPredicates());
                }
                case 6: {
                    return this.countsInMap(P2, this.store.getPredicates(), O, this.store.getObjects());
                }
                case 4: {
                    return this.countInMap(O, this.store.getObjects());
                }
                case 7: {
                    return this.store.contains(Triple.create(S, P2, O)) ? 1L : 0L;
                }
            }
            return -1L;
        }

        public long countsInMap(Node a, NodeToTriplesMapMem mapA, Node b, NodeToTriplesMapMem mapB) {
            long countA = this.countInMap(a, mapA);
            long countB = this.countInMap(b, mapB);
            return countA == 0L || countB == 0L ? 0L : -1L;
        }

        public long countInMap(Node n, NodeToTriplesMapMem map) {
            TripleBunch b = map.get(n.getIndexingValue());
            return b == null ? 0L : (long)b.size();
        }

        private static class C {
            static final int NONE = 0;
            static final int S = 1;
            static final int P = 2;
            static final int O = 4;
            static final int SP = 3;
            static final int SO = 5;
            static final int PO = 6;
            static final int SPO = 7;

            private C() {
            }
        }
    }
}

