/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.util.OneToManyMap;

public class TempNodeCache {
    protected OneToManyMap<NodePair, Node> ipMap = new OneToManyMap();
    protected Map<Node, Node> classMap = new HashMap<Node, Node>();

    public TempNodeCache(InfGraph infgraph) {
    }

    public synchronized Node getTemp(Node instance, Node prop, Node pclass) {
        NodePair ip = new NodePair(instance, prop);
        Node result2 = null;
        Iterator<Node> i = this.ipMap.getAll(ip);
        while (i.hasNext()) {
            Node t = i.next();
            if (pclass != null) {
                Node tClass = this.classMap.get(t);
                if (tClass == null || !((Object)tClass).equals(pclass)) continue;
                result2 = t;
                break;
            }
            result2 = t;
            break;
        }
        if (result2 == null) {
            result2 = NodeFactory.createBlankNode();
            this.ipMap.put(ip, result2);
            if (pclass != null) {
                this.classMap.put(result2, pclass);
            }
        }
        return result2;
    }

    public static class NodePair {
        protected Node first;
        protected Node second;

        public NodePair(Node first, Node second) {
            this.first = first;
            this.second = second;
        }

        public Node getFirst() {
            return this.first;
        }

        public Node getSecond() {
            return this.second;
        }

        public boolean equals(Object o) {
            return o instanceof NodePair && this.first.equals(((NodePair)o).first) && this.second.equals(((NodePair)o).second);
        }

        public int hashCode() {
            return this.first.hashCode() ^ this.second.hashCode() << 1;
        }
    }
}

