/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.query.ResultSet;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.resultset.ResultSetReader;
import org.apache.jena.riot.resultset.ResultSetReaderFactory;
import org.apache.jena.riot.resultset.ResultSetReaderRegistry;
import org.apache.jena.riot.resultset.ResultSetWriterFactory;
import org.apache.jena.riot.resultset.ResultSetWriterRegistry;
import org.apache.jena.sparql.util.Context;

public class ResultSetMgr {
    public static ResultSet read(InputStream in, Lang lang) {
        return ResultSetMgr.process(TypedInputStream.wrap(in), null, lang, null);
    }

    public static ResultSet read(String uri) {
        return ResultSetMgr.read(uri, null);
    }

    public static ResultSet read(String uri, Lang lang) {
        return ResultSetMgr.parse(uri, lang, null);
    }

    public static ResultSet parse(String uri, Lang hintLang, Context context) {
        TypedInputStream in;
        if (uri == null) {
            throw new IllegalArgumentException("URI to read from is null");
        }
        if (hintLang == null) {
            hintLang = RDFLanguages.filenameToLang(uri);
        }
        if ((in = RDFDataMgr.open(uri, context)) == null) {
            throw new RiotException("Not found: " + uri);
        }
        return ResultSetMgr.process(in, uri, hintLang, context);
    }

    private static ResultSet process(TypedInputStream in, String srcURI, Lang hintLang, Context context) {
        ContentType ct = WebContent.determineCT(in.getContentType(), hintLang, srcURI);
        if (ct == null) {
            throw new RiotException("Failed to determine the content type: (URI=" + srcURI + " : stream=" + in.getContentType() + " : hint=" + hintLang + ")");
        }
        ResultSetReader reader = ResultSetMgr.getReader(ct);
        if (reader == null) {
            throw new RiotException("No parser registered for content type: " + ct.getContentType());
        }
        return reader.read(in, context);
    }

    private static ResultSetReader getReader(ContentType ct) {
        Lang lang = RDFLanguages.contentTypeToLang(ct);
        if (lang == null) {
            return null;
        }
        ResultSetReaderFactory r = ResultSetReaderRegistry.getFactory(lang);
        if (r == null) {
            return null;
        }
        return r.create(lang);
    }

    public static void write(OutputStream out, ResultSet resultSet, Lang lang) {
        ResultSetWriterFactory f = ResultSetWriterRegistry.lookup(lang);
        if (f == null) {
            throw new RiotException("No resultSet writer for " + lang);
        }
        f.create(lang).write(out, resultSet, null);
    }

    public static void write(OutputStream out, boolean result2, Lang lang) {
        ResultSetWriterFactory f = ResultSetWriterRegistry.lookup(lang);
        if (f == null) {
            throw new RiotException("No resultSet writer for " + lang);
        }
        f.create(lang).write(out, result2, null);
    }

    static {
        ResultSetLang.init();
    }
}

