/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.assembler;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.ConstAssembler;
import org.apache.jena.assembler.JA;
import org.apache.jena.assembler.assemblers.AssemblerGroup;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.assembler.DatasetAssembler;
import org.apache.jena.sparql.core.assembler.DatasetAssemblerVocab;
import org.apache.jena.sparql.core.assembler.InMemDatasetAssembler;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.MappingRegistry;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.sparql.util.TypeNotUniqueException;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.system.JenaSystem;
import org.apache.jena.vocabulary.RDFS;

public class AssemblerUtils {
    private static boolean initialized = false;
    private static Model modelExtras;

    public static PrefixMapping readPrefixMapping(String file) {
        PrefixMapping pm = (PrefixMapping)AssemblerUtils.build(file, JA.PrefixMapping);
        return pm;
    }

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        AssemblerUtils.registerDataset(DatasetAssembler.getType(), new DatasetAssembler());
        AssemblerUtils.registerDataset(InMemDatasetAssembler.getType(), new InMemDatasetAssembler());
    }

    public static void registerDataset(Resource r, Assembler a) {
        AssemblerUtils.register(ConstAssembler.general(), r, a, DatasetAssembler.getType());
    }

    public static void registerModel(Resource r, Assembler a) {
        AssemblerUtils.register(ConstAssembler.general(), r, a, JA.Model);
    }

    public static void register(AssemblerGroup g, Resource r, Assembler a, Resource superType) {
        AssemblerUtils.registerAssembler(g, r, a);
        if (superType != null && !superType.equals(r)) {
            modelExtras.add(r, RDFS.Init.subClassOf(), superType);
        }
    }

    public static void registerAssembler(AssemblerGroup group, Resource r, Assembler a) {
        if (group == null) {
            group = ConstAssembler.general();
        }
        group.implementWith(r, a);
    }

    public static Model readAssemblerFile(String assemblerFile) {
        Model spec = null;
        try {
            spec = RDFDataMgr.loadModel(assemblerFile);
        }
        catch (Exception ex) {
            throw new ARQException("Failed reading assembler description: " + ex.getMessage());
        }
        spec.add(modelExtras);
        return spec;
    }

    public static Object build(String assemblerFile, String typeURI) {
        Resource type = ResourceFactory.createResource(typeURI);
        return AssemblerUtils.build(assemblerFile, type);
    }

    public static Object build(String assemblerFile, Resource type) {
        if (assemblerFile == null) {
            throw new ARQException("No assembler file");
        }
        Model spec = AssemblerUtils.readAssemblerFile(assemblerFile);
        Resource root2 = null;
        try {
            root2 = GraphUtils.findRootByType(spec, type);
            if (root2 == null) {
                return null;
            }
        }
        catch (TypeNotUniqueException ex) {
            throw new ARQException("Multiple types for: " + DatasetAssemblerVocab.tDataset);
        }
        return Assembler.general.open(root2);
    }

    public static void setContext(Resource r, Context context) {
        String qs = "PREFIX ja: <" + JA.getURI() + ">\nSELECT * { ?x ja:context [ ja:cxtName ?name ; ja:cxtValue ?value ] }";
        QuerySolutionMap qsm = new QuerySolutionMap();
        qsm.add("x", r);
        QueryExecution qExec = QueryExecutionFactory.create(qs, r.getModel(), (QuerySolution)qsm);
        ResultSet rs = qExec.execSelect();
        while (rs.hasNext()) {
            QuerySolution soln = rs.next();
            String name = soln.getLiteral("name").getLexicalForm();
            String value = soln.getLiteral("value").getLexicalForm();
            name = MappingRegistry.mapPrefixName(name);
            Symbol symbol = Symbol.create(name);
            if ("undef".equalsIgnoreCase(value)) {
                context.remove(symbol);
                continue;
            }
            context.set(symbol, value);
        }
    }

    static {
        JenaSystem.init();
        modelExtras = ModelFactory.createDefaultModel();
    }
}

