/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;

public class Rename {
    private static final String prefix = "/";

    public static Var chooseVarName(Var var, Collection<Var> inUse, String prefix) {
        Var var2 = var;
        while (inUse.contains(var2 = Var.alloc(prefix + var2.getName()))) {
        }
        return var2;
    }

    public static Op renameNode(Op op, Node oldName, Node newName) {
        RenameNode renamer = new RenameNode(oldName, newName);
        return NodeTransformLib.transform((NodeTransform)renamer, op);
    }

    public static Op renameVar(Op op, Var oldName, Var newName) {
        RenameNode renamer = new RenameNode(oldName, newName);
        return NodeTransformLib.transform((NodeTransform)renamer, op);
    }

    public static Op renameVars(Op op, Collection<Var> constants) {
        return NodeTransformLib.transform((NodeTransform)new RenameAnyVars(constants), op);
    }

    public static ExprList renameVars(ExprList exprList, Set<Var> constants) {
        RenameAnyVars renamer = new RenameAnyVars(constants);
        return NodeTransformLib.transform((NodeTransform)renamer, exprList);
    }

    public static Expr renameVars(Expr expr, Set<Var> constants) {
        RenameAnyVars renamer = new RenameAnyVars(constants);
        return NodeTransformLib.transform((NodeTransform)renamer, expr);
    }

    public static Op reverseVarRename(Op op, boolean repeatedly) {
        UnrenameAnyVars renamer = new UnrenameAnyVars(prefix, repeatedly);
        return NodeTransformLib.transform((NodeTransform)renamer, op);
    }

    static class UnrenameAnyVars
    implements NodeTransform {
        private final String varPrefix;
        private final boolean repeatedly;

        public UnrenameAnyVars(String varPrefix, boolean repeatedly) {
            this.varPrefix = varPrefix;
            this.repeatedly = repeatedly;
        }

        @Override
        public Node apply(Node node) {
            if (!Var.isVar(node)) {
                return node;
            }
            Var var = (Var)node;
            String varName = var.getName();
            if (this.repeatedly) {
                while (varName.startsWith(this.varPrefix)) {
                    varName = varName.substring(this.varPrefix.length());
                }
            } else if (varName.startsWith(this.varPrefix)) {
                varName = varName.substring(this.varPrefix.length());
            }
            if (varName == var.getName()) {
                return node;
            }
            return Var.alloc(varName);
        }
    }

    static class RenameAnyVars
    implements NodeTransform {
        private final Map<Var, Var> aliases = new HashMap<Var, Var>();
        private final Collection<Var> constants;

        public RenameAnyVars(Collection<Var> constants) {
            this.constants = constants;
        }

        @Override
        public final Node apply(Node node) {
            if (!Var.isVar(node)) {
                return node;
            }
            if (this.constants.contains(node)) {
                return node;
            }
            Var var = (Var)node;
            Var var2 = this.aliases.get(var);
            if (var2 != null) {
                return var2;
            }
            var2 = Rename.chooseVarName(var, this.constants, Rename.prefix);
            this.aliases.put(var, var2);
            return var2;
        }
    }

    static class RenameNode
    implements NodeTransform {
        private final Node oldName;
        private final Node newName;

        public RenameNode(Node oldName, Node newName) {
            this.oldName = oldName;
            this.newName = newName;
        }

        @Override
        public Node apply(Node node) {
            if (node.equals(this.oldName)) {
                return this.newName;
            }
            return node;
        }
    }
}

