/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.join;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterNullIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.engine.join.AbstractIterHashJoin;
import org.apache.jena.sparql.engine.join.JoinKey;
import org.apache.jena.sparql.expr.ExprList;

public class QueryIterHashLeftJoin_Left
extends AbstractIterHashJoin {
    private final ExprList conditions;
    private Set<Binding> leftHits = new HashSet<Binding>();

    public static QueryIterator create(JoinKey joinKey, QueryIterator left, QueryIterator right, ExprList conditions, ExecutionContext execCxt) {
        if (!left.hasNext()) {
            left.close();
            right.close();
            return QueryIterNullIterator.create(execCxt);
        }
        if (!right.hasNext()) {
            right.close();
            return left;
        }
        if (joinKey != null && joinKey.length() > 1) {
            Log.warn(QueryIterHashLeftJoin_Left.class, "Multivariable join key");
        }
        return new QueryIterHashLeftJoin_Left(joinKey, left, right, conditions, execCxt);
    }

    public static QueryIterator create(QueryIterator left, QueryIterator right, ExprList conditions, ExecutionContext execCxt) {
        return QueryIterHashLeftJoin_Left.create(null, left, right, conditions, execCxt);
    }

    private QueryIterHashLeftJoin_Left(JoinKey joinKey, QueryIterator left, QueryIterator right, ExprList conditions, ExecutionContext execCxt) {
        super(joinKey, left, right, execCxt);
        this.conditions = conditions;
    }

    @Override
    protected Binding yieldOneResult(Binding rowCurrentProbe, Binding rowStream, Binding rowResult) {
        if (this.conditions != null && !this.conditions.isSatisfied(rowResult, this.getExecContext())) {
            return null;
        }
        this.leftHits.add(rowCurrentProbe);
        return rowResult;
    }

    @Override
    protected Binding noYieldedRows(Binding rowCurrentProbe) {
        return null;
    }

    @Override
    protected QueryIterator joinFinished() {
        Iterator<Binding> iter = Iter.filter(this.hashTable.values(), b -> !this.leftHits.contains(b));
        return new QueryIterPlainWrapper(iter, this.getExecContext());
    }
}

