/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.optimizer.reorder;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.iterator.AccString;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.optimizer.reorder.PatternElements;
import org.apache.jena.sparql.engine.optimizer.reorder.PatternTriple;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderLib;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderProc;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderProcIndexes;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReorderTransformationSubstitution
implements ReorderTransformation {
    public static final Logger log = LoggerFactory.getLogger(ReorderTransformationSubstitution.class);
    private static final boolean DEBUG = false;

    @Override
    public BasicPattern reorder(BasicPattern pattern) {
        return this.reorderIndexes(pattern).reorder(pattern);
    }

    @Override
    public final ReorderProc reorderIndexes(BasicPattern pattern) {
        if (pattern.size() <= 1) {
            return ReorderLib.identityProc();
        }
        List<Triple> triples = pattern.getList();
        List<PatternTriple> components = Iter.toList(Iter.map(triples.iterator(), PatternTriple::new));
        components = this.modifyComponents(components);
        ReorderProc proc = this.reorder(triples, components);
        return proc;
    }

    protected List<PatternTriple> modifyComponents(List<PatternTriple> components) {
        return components;
    }

    private AccString<PatternTriple> formatter() {
        return new AccString<PatternTriple>(){

            @Override
            protected String toString(PatternTriple pt) {
                return "(" + StringUtils.printAbbrev(pt.toString()) + ")";
            }
        };
    }

    protected ReorderProc reorder(List<Triple> triples, List<PatternTriple> components) {
        int j;
        int idx;
        int N;
        int numReorder = N = components.size();
        int[] indexes = new int[N];
        for (idx = 0; idx < numReorder && (j = this.chooseNext(components)) >= 0; ++idx) {
            Triple triple = triples.get(j);
            indexes[idx] = j;
            ReorderTransformationSubstitution.update(triple, components);
            components.set(j, null);
        }
        for (int i = 0; i < components.size(); ++i) {
            if (components.get(i) == null) continue;
            indexes[idx++] = i;
        }
        if (triples.size() != idx) {
            throw new ARQException(String.format("Inconsistency: number of triples (%d) does not equal to number of indexes processed (%d)", triples.size(), idx));
        }
        ReorderProcIndexes proc = new ReorderProcIndexes(indexes);
        return proc;
    }

    protected int chooseNext(List<PatternTriple> pTriples) {
        int idx = this.processPTriples(pTriples, null);
        return idx;
    }

    protected List<Integer> chooseAll(List<PatternTriple> pTriples) {
        ArrayList<Integer> results = new ArrayList<Integer>(pTriples.size());
        this.processPTriples(pTriples, results);
        return results;
    }

    private int processPTriples(List<PatternTriple> pTriples, List<Integer> results) {
        double min2 = Double.MAX_VALUE;
        int N = pTriples.size();
        int idx = -1;
        for (int i = 0; i < N; ++i) {
            PatternTriple pt = pTriples.get(i);
            if (pt == null) continue;
            double x = this.weight(pt);
            if (x < 0.0) {
                DefaultChoice choice = this.defaultChoice(pt);
                if (choice != null) {
                    switch (choice) {
                        case FIRST: {
                            x = 0.01;
                            break;
                        }
                        case LAST: {
                            break;
                        }
                        case ZERO: {
                            x = 0.0;
                            break;
                        }
                        case NUMERIC: {
                            x = this.defaultWeight(pt);
                        }
                    }
                }
                if (idx != -1) continue;
                idx = i;
                if (results == null) continue;
                results.add(i);
                continue;
            }
            if (x == min2) {
                if (results == null) continue;
                results.add(i);
                continue;
            }
            if (!(x < min2)) continue;
            min2 = x;
            idx = i;
            if (results == null) continue;
            results.clear();
            results.add(i);
        }
        return idx;
    }

    protected abstract double weight(PatternTriple var1);

    protected DefaultChoice defaultChoice(PatternTriple pt) {
        return null;
    }

    protected double defaultWeight(PatternTriple pt) {
        return -1.0;
    }

    protected static void update(Triple triple, List<PatternTriple> components) {
        for (PatternTriple elt : components) {
            if (elt == null) continue;
            ReorderTransformationSubstitution.update(triple, elt);
        }
    }

    private static void update(Triple triple, PatternTriple tuple) {
        ReorderTransformationSubstitution.update(triple.getSubject(), tuple);
        ReorderTransformationSubstitution.update(triple.getPredicate(), tuple);
        ReorderTransformationSubstitution.update(triple.getObject(), tuple);
    }

    private static void update(Node node, PatternTriple elt) {
        if (Var.isVar(node)) {
            if (node.equals(elt.subject.getNode())) {
                elt.subject = PatternElements.TERM;
            }
            if (node.equals(elt.predicate.getNode())) {
                elt.predicate = PatternElements.TERM;
            }
            if (node.equals(elt.object.getNode())) {
                elt.object = PatternElements.TERM;
            }
        }
    }

    protected static void update(Var var, Node value, List<PatternTriple> components) {
        for (PatternTriple elt : components) {
            if (elt == null) continue;
            ReorderTransformationSubstitution.update(var, value, elt);
        }
    }

    private static void update(Var var, Node value, PatternTriple elt) {
        if (var.equals(elt.subject.getNode())) {
            elt.subject = Item.createNode(value);
        }
        if (var.equals(elt.predicate.getNode())) {
            elt.predicate = Item.createNode(value);
        }
        if (var.equals(elt.object.getNode())) {
            elt.object = Item.createNode(value);
        }
    }

    protected static enum DefaultChoice {
        ZERO,
        LAST,
        FIRST,
        NUMERIC;

    }
}

