/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.util.IdentityHashMap;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprFunctionN;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.util.LabelToNodeMap;
import org.apache.jena.sparql.util.Symbol;

public class E_BNode
extends ExprFunctionN {
    private static final String symbol = "bnode";
    private static final Symbol keyMap = Symbol.create("arq:internal:bNodeMappings");

    public E_BNode() {
        this((Expr)null);
    }

    public E_BNode(Expr expr) {
        super(symbol, expr);
    }

    @Override
    public NodeValue evalSpecial(Binding binding, FunctionEnv env) {
        LabelToNodeMap mapper;
        Expr expr = null;
        if (this.args.size() == 1) {
            expr = this.getArg(1);
        }
        if (expr == null) {
            return NodeValue.makeNode(NodeFactory.createBlankNode());
        }
        NodeValue x = expr.eval(binding, env);
        if (!x.isString()) {
            throw new ExprEvalException("Not a string: " + x);
        }
        Integer key = System.identityHashCode(binding);
        IdentityHashMap<Binding, LabelToNodeMap> mapping = (IdentityHashMap<Binding, LabelToNodeMap>)env.getContext().get(keyMap);
        if (mapping == null) {
            mapping = new IdentityHashMap<Binding, LabelToNodeMap>();
            env.getContext().set(keyMap, mapping);
        }
        if ((mapper = (LabelToNodeMap)mapping.get(binding)) == null) {
            mapper = LabelToNodeMap.createBNodeMap();
            mapping.put(binding, mapper);
        }
        Node bnode2 = mapper.asNode(x.getString());
        return NodeValue.makeNode(bnode2);
    }

    @Override
    public NodeValue eval(List<NodeValue> args) {
        throw new ARQInternalErrorException();
    }

    @Override
    public Expr copy(ExprList newArgs) {
        if (newArgs.size() == 0) {
            return new E_BNode();
        }
        return new E_BNode(newArgs.get(0));
    }
}

