/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.nodevalue;

import java.util.Iterator;
import java.util.UUID;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.iri.Violation;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprTypeException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.sparql.util.NodeUtils;
import org.apache.jena.vocabulary.XSD;

public class NodeFunctions {
    private static final NodeValue xsdString = NodeValue.makeNode(XSD.xstring.asNode());
    private static final IRIFactory iriFactory = IRIFactory.iriImplementation();
    public static boolean warningsForIRIs = false;

    public static Node checkAndGetStringLiteral(String label, NodeValue nv) {
        Node n = nv.asNode();
        if (!n.isLiteral()) {
            throw new ExprEvalException(label + ": Not a literal: " + nv);
        }
        String lang = n.getLiteralLanguage();
        if (NodeUtils.isLangString(n)) {
            return n;
        }
        if (nv.isString()) {
            return n;
        }
        throw new ExprEvalException(label + ": Not a string literal: " + nv);
    }

    public static void checkTwoArgumentStringLiterals(String label, NodeValue arg1, NodeValue arg2) {
        Node n1 = NodeFunctions.checkAndGetStringLiteral(label, arg1);
        Node n2 = NodeFunctions.checkAndGetStringLiteral(label, arg2);
        String lang1 = n1.getLiteralLanguage();
        String lang2 = n2.getLiteralLanguage();
        if (lang1 == null) {
            lang1 = "";
        }
        if (lang2 == null) {
            lang2 = "";
        }
        if (lang1.equals("")) {
            if (lang2.equals("")) {
                return;
            }
            throw new ExprEvalException(label + ": Incompatible: " + arg1 + " and " + arg2);
        }
        if (lang1.equalsIgnoreCase(lang2)) {
            return;
        }
        if (lang2.equals("")) {
            return;
        }
        throw new ExprEvalException(label + ": Incompatible: " + arg1 + " and " + arg2);
    }

    public static NodeValue sameTerm(NodeValue nv1, NodeValue nv2) {
        return NodeValue.booleanReturn(NodeFunctions.sameTerm(nv1.asNode(), nv2.asNode()));
    }

    public static boolean sameTerm(Node n1, Node n2) {
        if (n1.equals(n2)) {
            return true;
        }
        if (n1.isLiteral() && n2.isLiteral()) {
            boolean b;
            String lang1 = n1.getLiteralLanguage();
            String lang2 = n2.getLiteralLanguage();
            if (!lang1.equals("") && lang1.equalsIgnoreCase(lang2) && (b = n1.getLiteralLexicalForm().equals(n2.getLiteralLexicalForm()))) {
                return true;
            }
        }
        return false;
    }

    public static NodeValue rdfTermEquals(NodeValue nv1, NodeValue nv2) {
        return NodeValue.booleanReturn(NodeFunctions.rdfTermEquals(nv1.asNode(), nv2.asNode()));
    }

    public static boolean rdfTermEquals(Node n1, Node n2) {
        if (n1.equals(n2)) {
            return true;
        }
        if (n1.isLiteral() && n2.isLiteral()) {
            boolean b;
            String lang1 = n1.getLiteralLanguage();
            String lang2 = n2.getLiteralLanguage();
            if (!lang1.equals("") && lang1.equalsIgnoreCase(lang2) && (b = n1.getLiteralLexicalForm().equals(n2.getLiteralLexicalForm()))) {
                return true;
            }
            NodeValue.raise(new ExprEvalException("Mismatch in RDFterm-equals: " + n1 + ", " + n2));
        }
        return false;
    }

    public static NodeValue str(NodeValue nv) {
        return NodeValue.makeString(NodeFunctions.str(nv.asNode()));
    }

    public static String str(Node node) {
        if (node.isLiteral()) {
            return node.getLiteral().getLexicalForm();
        }
        if (node.isURI()) {
            return node.getURI();
        }
        if (node.isBlank()) {
            NodeValue.raise(new ExprTypeException("Blank node: " + node));
        }
        NodeValue.raise(new ExprEvalException("Not a string: " + node));
        return "[undef]";
    }

    public static NodeValue sortKey(NodeValue nv, String collation) {
        return NodeValue.makeSortKey(NodeFunctions.str(nv.asNode()), collation);
    }

    public static NodeValue datatype(NodeValue nv) {
        return NodeValue.makeNode(NodeFunctions.datatype(nv.asNode()));
    }

    public static Node datatype(Node node) {
        boolean plainLiteral;
        if (!node.isLiteral()) {
            NodeValue.raise(new ExprTypeException("datatype: Not a literal: " + node));
            return null;
        }
        String s = node.getLiteralDatatypeURI();
        boolean bl = plainLiteral = s == null || s.equals("");
        if (plainLiteral) {
            boolean simpleLiteral;
            boolean bl2 = simpleLiteral = node.getLiteralLanguage() == null || node.getLiteralLanguage().equals("");
            if (!simpleLiteral) {
                return NodeConst.rdfLangString;
            }
            return XSD.xstring.asNode();
        }
        return NodeFactory.createURI(s);
    }

    public static NodeValue lang(NodeValue nv) {
        if (nv.isLangString()) {
            return NodeValue.makeString(nv.getLang());
        }
        if (nv.isLiteral()) {
            return NodeValue.nvEmptyString;
        }
        NodeValue.raise(new ExprTypeException("lang: Not a literal: " + nv.asQuotedString()));
        return null;
    }

    public static String lang(Node node) {
        String s;
        if (!node.isLiteral()) {
            NodeValue.raise(new ExprTypeException("lang: Not a literal: " + FmtUtils.stringForNode(node)));
        }
        if ((s = node.getLiteralLanguage()) == null) {
            s = "";
        }
        return s;
    }

    public static NodeValue langMatches(NodeValue nv, NodeValue nvPattern) {
        return NodeFunctions.langMatches(nv, nvPattern.getString());
    }

    public static NodeValue langMatches(NodeValue nv, String langPattern) {
        String range;
        Node node = nv.asNode();
        if (!node.isLiteral()) {
            NodeValue.raise(new ExprTypeException("langMatches: not a literal: " + node));
            return null;
        }
        String nodeLang = node.getLiteralLexicalForm();
        if (langPattern.equals("*")) {
            if (nodeLang == null || nodeLang.equals("")) {
                return NodeValue.FALSE;
            }
            return NodeValue.TRUE;
        }
        String[] langElts = nodeLang.split("-");
        String[] langRangeElts = langPattern.split("-");
        if (langRangeElts.length > langElts.length) {
            return NodeValue.FALSE;
        }
        for (int i = 0; i < langRangeElts.length && (range = langRangeElts[i]) != null && i < langElts.length; ++i) {
            String lang = langElts[i];
            if (range.equals("*") || range.equalsIgnoreCase(lang)) continue;
            return NodeValue.FALSE;
        }
        return NodeValue.TRUE;
    }

    public static NodeValue isIRI(NodeValue nv) {
        return NodeValue.booleanReturn(NodeFunctions.isIRI(nv.asNode()));
    }

    public static boolean isIRI(Node node) {
        return node.isURI();
    }

    public static NodeValue isURI(NodeValue nv) {
        return NodeValue.booleanReturn(NodeFunctions.isIRI(nv.asNode()));
    }

    public static boolean isURI(Node node) {
        return NodeFunctions.isIRI(node);
    }

    public static NodeValue isBlank(NodeValue nv) {
        return NodeValue.booleanReturn(NodeFunctions.isBlank(nv.asNode()));
    }

    public static boolean isBlank(Node node) {
        return node.isBlank();
    }

    public static NodeValue isLiteral(NodeValue nv) {
        return NodeValue.booleanReturn(NodeFunctions.isLiteral(nv.asNode()));
    }

    public static boolean isLiteral(Node node) {
        return node.isLiteral();
    }

    public static NodeValue iri(NodeValue nv, String baseIRI) {
        if (NodeFunctions.isIRI(nv.asNode())) {
            return nv;
        }
        Node n2 = NodeFunctions.iri(nv.asNode(), baseIRI);
        return NodeValue.makeNode(n2);
    }

    public static Node iri(Node nv, String baseIRI) {
        if (nv.isURI()) {
            return nv;
        }
        if (nv.isBlank()) {
            String x = nv.getBlankNodeLabel();
            return NodeFactory.createURI("_:" + x);
        }
        String str2 = NodeFunctions.simpleLiteralOrXSDString(nv);
        if (str2 == null) {
            throw new ExprEvalException("Can't make an IRI from " + nv);
        }
        IRI iri = null;
        String iriStr = nv.getLiteralLexicalForm();
        if (baseIRI != null) {
            IRI base = iriFactory.create(baseIRI);
            iri = base.create(iriStr);
        } else {
            iri = iriFactory.create(iriStr);
        }
        if (!iri.isAbsolute()) {
            throw new ExprEvalException("Relative IRI string: " + iriStr);
        }
        if (warningsForIRIs && iri.hasViolation(false)) {
            String msg = "unknown violation from IRI library";
            Iterator<Violation> iter = iri.violations(false);
            if (iter.hasNext()) {
                Violation viol = iter.next();
                msg = viol.getShortMessage();
            }
            Log.warn(NodeFunctions.class, "Bad IRI: " + msg + ": " + iri);
        }
        return NodeFactory.createURI(iri.toString());
    }

    public static NodeValue struuid() {
        return NodeValue.makeString(NodeFunctions.uuidString());
    }

    public static NodeValue uuid() {
        String str2 = "urn:uuid:" + NodeFunctions.uuidString();
        Node n = NodeFactory.createURI(str2);
        return NodeValue.makeNode(n);
    }

    private static String uuidString() {
        return UUID.randomUUID().toString();
    }

    private static String simpleLiteralOrXSDString(Node n) {
        if (!n.isLiteral()) {
            return null;
        }
        if (n.getLiteralDatatype() == null ? n.getLiteralLanguage().equals("") : n.getLiteralDatatype().equals(XSDDatatype.XSDstring)) {
            return n.getLiteralLexicalForm();
        }
        return null;
    }

    public static NodeValue strDatatype(NodeValue v1, NodeValue v2) {
        if (!v1.isString()) {
            throw new ExprEvalException("Not a string (arg 1): " + v1);
        }
        if (!v2.isIRI()) {
            throw new ExprEvalException("Not an IRI (arg 2): " + v2);
        }
        String lex = v1.asString();
        Node dt = v2.asNode();
        Node n = NodeFactory.createLiteral(lex, NodeFactory.getType(dt.getURI()));
        return NodeValue.makeNode(n);
    }

    public static NodeValue strLang(NodeValue v1, NodeValue v2) {
        if (!v1.isString()) {
            throw new ExprEvalException("Not a string (arg 1): " + v1);
        }
        if (!v2.isString()) {
            throw new ExprEvalException("Not a string (arg 2): " + v2);
        }
        String lex = v1.asString();
        String lang = v2.asString();
        if (lang.isEmpty()) {
            throw new ExprEvalException("Empty lang tag");
        }
        return NodeValue.makeLangString(lex, lang);
    }
}

