/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jena.atlas.lib.Callback;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.sparql.util.Symbol;

public class Context {
    public static final Context emptyContext = new Context(true);
    protected Map<Symbol, Object> context = new ConcurrentHashMap<Symbol, Object>();
    protected List<Callback<Symbol>> callbacks = new ArrayList<Callback<Symbol>>();
    protected boolean readonly = false;

    public Context() {
    }

    private Context(boolean readonly) {
        this.readonly = readonly;
    }

    public Context(Context cxt) {
        this.putAll(cxt);
    }

    public Context copy() {
        return new Context(this);
    }

    public <T> T get(Symbol property) {
        return (T)this.context.get(property);
    }

    public Object get(Symbol property, Object defaultValue) {
        Object x = this.context.get(property);
        if (x == null) {
            return defaultValue;
        }
        return x;
    }

    public void put(Symbol property, Object value) {
        this._put(property, value);
        this.doCallbacks(property);
    }

    public void set(Symbol property, Object value) {
        this._put(property, value);
        this.doCallbacks(property);
    }

    private void _put(Symbol property, Object value) {
        if (this.readonly) {
            throw new ARQException("Context is readonly");
        }
        if (property == null) {
            throw new ARQException("Context key is null");
        }
        if (value == null) {
            this.context.remove(property);
            return;
        }
        this.context.put(property, value);
    }

    public void set(Symbol property, boolean value) {
        if (value) {
            this.setTrue(property);
        } else {
            this.setFalse(property);
        }
    }

    public void setIfUndef(Symbol property, Object value) {
        Object x = this.context.get(property);
        if (x == null) {
            this.put(property, value);
        }
    }

    public void remove(Symbol property) {
        this.context.remove(property);
        this.doCallbacks(property);
    }

    public void unset(Symbol property) {
        this.context.remove(property);
        this.doCallbacks(property);
    }

    public boolean isDefined(Symbol property) {
        return this.context.containsKey(property);
    }

    public boolean isUndef(Symbol property) {
        return !this.isDefined(property);
    }

    public String getAsString(Symbol property, String defaultValue) {
        String x = this.getAsString(property);
        if (x == null) {
            return defaultValue;
        }
        return x;
    }

    public String getAsString(Symbol property) {
        Object x = this.context.get(property);
        if (x == null) {
            return null;
        }
        return x.toString();
    }

    public int getInt(Symbol symbol, int defaultValue) {
        if (this.isUndef(symbol)) {
            return defaultValue;
        }
        Object obj = this.context.get(symbol);
        if (obj instanceof String) {
            return Integer.parseInt((String)obj);
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        throw new ARQException("Value for " + symbol + " is not a recoginized class: " + Lib.className(obj));
    }

    public long getLong(Symbol symbol, long defaultValue) {
        if (this.isUndef(symbol)) {
            return defaultValue;
        }
        Object obj = this.context.get(symbol);
        if (obj instanceof String) {
            return Long.parseLong((String)obj);
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).intValue();
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        throw new ARQException("Value for " + symbol + " is not a recoginized class: " + Lib.className(obj));
    }

    public void putAll(Context other) {
        if (this.readonly) {
            throw new ARQException("Context is readonly");
        }
        if (other != null) {
            for (Map.Entry<Symbol, Object> e2 : other.context.entrySet()) {
                this.put(e2.getKey(), e2.getValue());
            }
        }
    }

    public void setTrue(Symbol property) {
        this.set(property, Boolean.TRUE);
    }

    public void setFalse(Symbol property) {
        this.set(property, Boolean.FALSE);
    }

    public boolean isTrue(Symbol property) {
        return this.isTrue(property, false);
    }

    public boolean isTrueOrUndef(Symbol property) {
        return this.isTrue(property, true);
    }

    private boolean isTrue(Symbol property, boolean dft) {
        String s;
        Object x = this.get(property);
        if (x == null) {
            return dft;
        }
        if (x instanceof String && (s = (String)x).equalsIgnoreCase("true")) {
            return true;
        }
        return x.equals(Boolean.TRUE);
    }

    public boolean isFalse(Symbol property) {
        return this.isFalse(property, false);
    }

    public boolean isFalseOrUndef(Symbol property) {
        return this.isFalse(property, true);
    }

    private boolean isFalse(Symbol property, boolean dft) {
        String s;
        Object x = this.get(property);
        if (x == null) {
            return dft;
        }
        if (x instanceof String && (s = (String)x).equalsIgnoreCase("false")) {
            return true;
        }
        return x.equals(Boolean.FALSE);
    }

    public boolean hasValue(Symbol property, Object value) {
        Object x = this.get(property);
        if (x == null && value == null) {
            return true;
        }
        if (x == null || value == null) {
            return false;
        }
        return x.equals(value);
    }

    public boolean hasValueAsString(Symbol property, String value) {
        return this.hasValueAsString(property, value, false);
    }

    public boolean hasValueAsString(Symbol property, String value, boolean ignoreCase) {
        String s = this.getAsString(property);
        if (s == null && value == null) {
            return true;
        }
        if (s == null || value == null) {
            return false;
        }
        if (ignoreCase) {
            return s.equalsIgnoreCase(value);
        }
        return s.equals(value);
    }

    public Set<Symbol> keys() {
        return this.context.keySet();
    }

    public int size() {
        return this.context.size();
    }

    public synchronized void addCallback(Callback<Symbol> m) {
        this.callbacks.add(m);
    }

    public synchronized void removeCallback(Callback<Symbol> m) {
        this.callbacks.remove(m);
    }

    public synchronized List<Callback<Symbol>> getCallbacks() {
        return Collections.unmodifiableList(this.callbacks);
    }

    private synchronized void doCallbacks(Symbol symbol) {
        for (Callback<Symbol> c : this.callbacks) {
            c.apply(symbol);
        }
    }

    public String toString() {
        String x = "";
        String sep = "";
        for (Symbol s : this.keys()) {
            Object value = this.get(s);
            x = x + sep + s + " = " + value;
            sep = "\n";
        }
        return x;
    }

    public static Context setupContext(Context context, DatasetGraph dataset) {
        if (context == null) {
            context = ARQ.getContext();
        }
        context = context.copy();
        if (dataset != null && dataset.getContext() != null) {
            context.putAll(dataset.getContext());
        }
        context.set(ARQConstants.sysCurrentTime, NodeFactoryExtra.nowAsDateTime());
        return context;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.context == null ? 0 : this.context.hashCode());
        result2 = 31 * result2 + (this.readonly ? 1231 : 1237);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Context other = (Context)obj;
        if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
            return false;
        }
        return this.readonly == other.readonly;
    }
}

