/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.io.OutputStream;
import java.util.List;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.ResultSetMgr;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.resultset.PlainFormat;
import org.apache.jena.sparql.resultset.RDFOutput;
import org.apache.jena.sparql.resultset.ResultSetApply;
import org.apache.jena.sparql.resultset.ResultsFormat;
import org.apache.jena.sparql.vocabulary.ResultSetGraphVocab;

public class QueryExecUtils {
    protected static PrefixMapping globalPrefixMap = new PrefixMappingImpl();
    protected static Prologue dftPrologue;

    public static void executeQuery(QueryExecution queryExecution) {
        QueryExecUtils.executeQuery(null, queryExecution);
    }

    public static void executeQuery(Prologue prologue, QueryExecution queryExecution) {
        QueryExecUtils.executeQuery(prologue, queryExecution, ResultsFormat.FMT_TEXT);
    }

    public static void executeQuery(Prologue prologue, QueryExecution queryExecution, ResultsFormat outputFormat) {
        Query query = queryExecution.getQuery();
        if (prologue == null) {
            prologue = query.getPrologue();
        }
        if (prologue == null) {
            prologue = dftPrologue;
        }
        if (query.isSelectType()) {
            QueryExecUtils.doSelectQuery(prologue, queryExecution, outputFormat);
        }
        if (query.isDescribeType()) {
            QueryExecUtils.doDescribeQuery(prologue, queryExecution, outputFormat);
        }
        if (query.isConstructType()) {
            QueryExecUtils.doConstructQuery(prologue, queryExecution, outputFormat);
        }
        if (query.isAskType()) {
            QueryExecUtils.doAskQuery(prologue, queryExecution, outputFormat);
        }
        queryExecution.close();
    }

    public static void execute(Op op, DatasetGraph dsg) {
        QueryExecUtils.execute(op, dsg, ResultsFormat.FMT_TEXT);
    }

    public static void execute(Op op, DatasetGraph dsg, ResultsFormat outputFormat) {
        QueryIterator qIter = Algebra.exec(op, dsg);
        List<String> vars = null;
        vars = op instanceof OpProject ? Var.varNames(((OpProject)op).getVars()) : Var.varNames(OpVars.visibleVars(op));
        ResultSet results = ResultSetFactory.create(qIter, vars);
        QueryExecUtils.outputResultSet(results, null, outputFormat);
    }

    public static void outputResultSet(ResultSet results, Prologue prologue, ResultsFormat outputFormat) {
        Lang lang = ResultsFormat.convert(outputFormat);
        if (lang != null) {
            ResultSetMgr.write((OutputStream)System.out, results, lang);
            System.out.flush();
            return;
        }
        boolean done = false;
        if (prologue == null) {
            prologue = new Prologue(globalPrefixMap);
        }
        if (outputFormat.equals(ResultsFormat.FMT_UNKNOWN)) {
            outputFormat = ResultsFormat.FMT_TEXT;
        }
        if (outputFormat.equals(ResultsFormat.FMT_NONE) || outputFormat.equals(ResultsFormat.FMT_COUNT)) {
            int count = ResultSetFormatter.consume(results);
            if (outputFormat.equals(ResultsFormat.FMT_COUNT)) {
                System.out.println("Count = " + count);
            }
            done = true;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RDF_XML) || outputFormat.equals(ResultsFormat.FMT_RDF_N3) || outputFormat.equals(ResultsFormat.FMT_RDF_TTL)) {
            Model m = RDFOutput.encodeAsModel(results);
            m.setNsPrefixes(prologue.getPrefixMapping());
            m.setNsPrefix("rs", ResultSetGraphVocab.getURI());
            RDFDataMgr.write((OutputStream)System.out, m, Lang.TURTLE);
            done = true;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RS_XML)) {
            ResultSetFormatter.outputAsXML((OutputStream)System.out, results);
            done = true;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RS_JSON)) {
            ResultSetFormatter.outputAsJSON((OutputStream)System.out, results);
            done = true;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RS_SSE)) {
            ResultSetFormatter.outputAsSSE(System.out, results, prologue);
            done = true;
        }
        if (outputFormat.equals(ResultsFormat.FMT_TEXT)) {
            ResultSetFormatter.out((OutputStream)System.out, results, prologue);
            done = true;
        }
        if (outputFormat.equals(ResultsFormat.FMT_TUPLES)) {
            PlainFormat pFmt = new PlainFormat((OutputStream)System.out, prologue);
            ResultSetApply a = new ResultSetApply(results, pFmt);
            a.apply();
            done = true;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RS_CSV)) {
            ResultSetFormatter.outputAsCSV((OutputStream)System.out, results);
            done = true;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RS_TSV)) {
            ResultSetFormatter.outputAsTSV((OutputStream)System.out, results);
            done = true;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RS_BIO)) {
            ResultSetFormatter.outputAsBIO(System.out, results);
            done = true;
        }
        if (!done) {
            System.err.println("Unknown format request: " + outputFormat);
        }
        results = null;
        System.out.flush();
    }

    private static void doSelectQuery(Prologue prologue, QueryExecution qe, ResultsFormat outputFormat) {
        if (prologue == null) {
            prologue = qe.getQuery().getPrologue();
        }
        if (outputFormat == null || outputFormat == ResultsFormat.FMT_UNKNOWN) {
            outputFormat = ResultsFormat.FMT_TEXT;
        }
        ResultSet results = qe.execSelect();
        QueryExecUtils.outputResultSet(results, prologue, outputFormat);
    }

    private static void doDescribeQuery(Prologue prologue, QueryExecution qe, ResultsFormat outputFormat) {
        if (outputFormat == null || outputFormat == ResultsFormat.FMT_UNKNOWN) {
            outputFormat = ResultsFormat.FMT_RDF_TTL;
        }
        Model r = qe.execDescribe();
        QueryExecUtils.writeModel(prologue, r, outputFormat);
    }

    private static void doConstructQuery(Prologue prologue, QueryExecution qe, ResultsFormat outputFormat) {
        if (outputFormat == null || outputFormat == ResultsFormat.FMT_UNKNOWN) {
            outputFormat = ResultsFormat.FMT_RDF_TTL;
        }
        Model r = qe.execConstruct();
        QueryExecUtils.writeModel(prologue, r, outputFormat);
    }

    private static void writeModel(Prologue prologue, Model model, ResultsFormat outputFormat) {
        if (outputFormat == null || outputFormat == ResultsFormat.FMT_UNKNOWN) {
            outputFormat = ResultsFormat.FMT_TEXT;
        }
        if (outputFormat.equals(ResultsFormat.FMT_NONE)) {
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_TEXT)) {
            System.out.println("# ======== ");
            RDFDataMgr.write((OutputStream)System.out, model, Lang.TURTLE);
            System.out.println("# ======== ");
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RDF_XML)) {
            model.write(System.out, "RDF/XML-ABBREV", null);
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RDF_TTL)) {
            model.write(System.out, "N3", null);
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RDF_N3)) {
            model.write(System.out, "N3", null);
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RDF_NT)) {
            model.write(System.out, "N-TRIPLES", null);
            return;
        }
        System.err.println("Unknown format: " + outputFormat);
    }

    private static void doAskQuery(Prologue prologue, QueryExecution qe, ResultsFormat outputFormat) {
        boolean b = qe.execAsk();
        if (outputFormat == null || outputFormat == ResultsFormat.FMT_UNKNOWN) {
            outputFormat = ResultsFormat.FMT_TEXT;
        }
        if (outputFormat.equals(ResultsFormat.FMT_NONE)) {
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RS_XML)) {
            ResultSetFormatter.outputAsXML((OutputStream)System.out, b);
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RDF_N3) || outputFormat.equals(ResultsFormat.FMT_RDF_TTL)) {
            RDFOutput.outputAsRDF((OutputStream)System.out, "TURTLE", b);
            System.out.flush();
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RS_JSON)) {
            ResultSetFormatter.outputAsJSON((OutputStream)System.out, b);
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_TEXT)) {
            System.out.println("Ask => " + (b ? "Yes" : "No"));
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RS_CSV)) {
            ResultSetFormatter.outputAsCSV((OutputStream)System.out, b);
            return;
        }
        if (outputFormat.equals(ResultsFormat.FMT_RS_TSV)) {
            ResultSetFormatter.outputAsTSV((OutputStream)System.out, b);
            return;
        }
        System.err.println("Unknown format: " + outputFormat);
    }

    public static RDFNode getExactlyOne(String qs, Model model) {
        return QueryExecUtils.getExactlyOne(qs, DatasetFactory.create(model));
    }

    public static RDFNode getExactlyOne(String qs, Dataset ds) {
        Query q = QueryFactory.create(qs);
        if (q.getResultVars().size() != 1) {
            throw new ARQException("getExactlyOne: Must have exactly one result columns");
        }
        String varname = q.getResultVars().get(0);
        QueryExecution qExec = QueryExecutionFactory.create(q, ds);
        return QueryExecUtils.getExactlyOne(qExec, varname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RDFNode getExactlyOne(QueryExecution qExec, String varname) {
        try {
            ResultSet rs = qExec.execSelect();
            if (!rs.hasNext()) {
                throw new ARQException("Not found: var ?" + varname);
            }
            QuerySolution qs = rs.nextSolution();
            RDFNode r = qs.get(varname);
            if (rs.hasNext()) {
                throw new ARQException("More than one: var ?" + varname);
            }
            RDFNode rDFNode = r;
            return rDFNode;
        }
        finally {
            qExec.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RDFNode getOne(QueryExecution qExec, String varname) {
        try {
            ResultSet rs = qExec.execSelect();
            if (!rs.hasNext()) {
                RDFNode rDFNode = null;
                return rDFNode;
            }
            QuerySolution qs = rs.nextSolution();
            RDFNode r = qs.get(varname);
            if (rs.hasNext()) {
                QuerySolution qs2 = rs.next();
                RDFNode r2 = qs2.get(varname);
                if (rs.hasNext()) {
                    throw new ARQException("More than one: var ?" + varname + " -> " + r + ", " + r2 + ", ...");
                }
                throw new ARQException("Found two matches: var ?" + varname + " -> " + r + ", " + r2);
            }
            RDFNode rDFNode = r;
            return rDFNode;
        }
        finally {
            qExec.close();
        }
    }

    static {
        globalPrefixMap.setNsPrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        globalPrefixMap.setNsPrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        globalPrefixMap.setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        globalPrefixMap.setNsPrefix("owl", "http://www.w3.org/2002/07/owl#");
        globalPrefixMap.setNsPrefix("ex", "http://example.org/");
        globalPrefixMap.setNsPrefix("ns", "http://example.org/ns#");
        globalPrefixMap.setNsPrefix("", "http://example/");
        dftPrologue = new Prologue(globalPrefixMap);
    }
}

