/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.arq;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.DatasetImpl;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.sparql.util.FmtUtils;
import org.topbraid.shacl.arq.OptionalArgsFunction;
import org.topbraid.shacl.arq.SHACLFunctionsCache;
import org.topbraid.shacl.model.SHFunction;
import org.topbraid.shacl.model.SHParameter;
import org.topbraid.shacl.model.SHParameterizable;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.spin.arq.SPINFunctionFactory;
import org.topbraid.spin.statistics.SPINStatistics;
import org.topbraid.spin.statistics.SPINStatisticsManager;
import org.topbraid.spin.util.JenaDatatypes;
import org.topbraid.spin.util.JenaUtil;

public abstract class SHACLARQFunction
implements Function,
OptionalArgsFunction,
SPINFunctionFactory {
    private boolean cachable;
    protected List<String> paramNames = new ArrayList<String>();
    private List<Boolean> optional = new ArrayList<Boolean>();
    private SHFunction shFunction;

    protected SHACLARQFunction(SHFunction shaclFunction) {
        this.shFunction = shaclFunction;
        if (shaclFunction != null) {
            this.cachable = shaclFunction.hasProperty(DASH.cachable, JenaDatatypes.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addParameters(SHParameterizable parameterizable) {
        JenaUtil.setGraphReadOptimization(true);
        try {
            for (SHParameter param2 : parameterizable.getOrderedParameters()) {
                String varName = param2.getVarName();
                if (varName == null) {
                    throw new IllegalStateException(param2 + " of " + parameterizable + " does not have a valid predicate");
                }
                this.paramNames.add(varName);
                this.optional.add(param2.isOptional());
            }
        }
        finally {
            JenaUtil.setGraphReadOptimization(false);
        }
    }

    @Override
    public void build(String uri, ExprList args) {
    }

    @Override
    public Function create(String uri) {
        return this;
    }

    @Override
    public NodeValue exec(Binding binding, ExprList args, String uri, FunctionEnv env) {
        Graph activeGraph = env.getActiveGraph();
        Model model = activeGraph != null ? ModelFactory.createModelForGraph(activeGraph) : ModelFactory.createDefaultModel();
        QuerySolutionMap bindings = new QuerySolutionMap();
        Node[] paramsForCache = this.cachable ? new Node[args.size()] : null;
        for (int i = 0; i < args.size(); ++i) {
            Expr expr = args.get(i);
            if (expr == null || expr.isVariable() && !binding.contains(expr.asVar())) continue;
            NodeValue x = expr.eval(binding, env);
            if (x != null) {
                String paramName = i < this.paramNames.size() ? this.paramNames.get(i) : "arg" + (i + 1);
                bindings.add(paramName, model.asRDFNode(x.asNode()));
                if (!this.cachable) continue;
                paramsForCache[i] = x.asNode();
                continue;
            }
            if (this.optional.get(i).booleanValue()) continue;
            throw new ExprEvalException("Missing SHACL function argument");
        }
        Dataset dataset = DatasetImpl.wrap(env.getDataset());
        if (SPINStatisticsManager.get().isRecording() && SPINStatisticsManager.get().isRecordingSPINFunctions()) {
            NodeValue result2;
            StringBuffer sb = new StringBuffer();
            sb.append("SHACL Function ");
            sb.append(SSE.str(NodeFactory.createURI(uri), (PrefixMapping)model));
            sb.append("(");
            for (int i = 0; i < args.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                Expr expr = args.get(i);
                if ((expr = Substitute.substitute(expr, binding)) == null) {
                    sb.append("?unbound");
                    continue;
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                IndentedWriter iOut = new IndentedWriter(bos);
                ExprUtils.fmtSPARQL(iOut, expr, new SerializationContext(model));
                iOut.flush();
                sb.append(bos.toString());
            }
            sb.append(")");
            long startTime = System.currentTimeMillis();
            try {
                result2 = this.cachable ? SHACLFunctionsCache.get().execute(this, dataset, model, bindings, paramsForCache) : this.executeBody(dataset, model, bindings);
                sb.append(" = ");
                sb.append(FmtUtils.stringForNode(result2.asNode(), model));
            }
            catch (ExprEvalException ex) {
                sb.append(" : ");
                sb.append(ex.getLocalizedMessage());
                throw ex;
            }
            finally {
                long endTime = System.currentTimeMillis();
                SPINStatistics stats = new SPINStatistics(sb.toString(), this.getQueryString(), endTime - startTime, startTime, NodeFactory.createURI(uri));
                SPINStatisticsManager.get().addSilently(Collections.singleton(stats));
            }
            return result2;
        }
        if (this.cachable) {
            return SHACLFunctionsCache.get().execute(this, dataset, model, bindings, paramsForCache);
        }
        return this.executeBody(dataset, model, bindings);
    }

    public abstract NodeValue executeBody(Dataset var1, Model var2, QuerySolution var3);

    protected abstract String getQueryString();

    public SHFunction getSHACLFunction() {
        return this.shFunction;
    }

    public String[] getParamNames() {
        return this.paramNames.toArray(new String[0]);
    }

    @Override
    public boolean isOptionalArg(int index) {
        return this.optional.get(index);
    }
}

