/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.engine.filters;

import java.util.function.Predicate;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.shacl.model.SHShape;
import org.topbraid.shacl.vocabulary.SH;

public class MinSeverityShapeFilter
implements Predicate<SHShape> {
    private Integer minSeverityScore;

    public MinSeverityShapeFilter(Resource minSeverity) {
        this.minSeverityScore = this.getScore(minSeverity);
    }

    private Integer getScore(Resource severity) {
        if (SH.Violation.equals(severity)) {
            return 2;
        }
        if (SH.Warning.equals(severity)) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean test(SHShape shape) {
        Resource severity = shape.getSeverity();
        Integer score = this.getScore(severity);
        return score.compareTo(this.minSeverityScore) >= 0;
    }
}

