/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.model;

import org.apache.jena.enhanced.BuiltinPersonalities;
import org.apache.jena.enhanced.Personality;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.apache.jena.sparql.pfunction.PropertyFunctionRegistry;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.shacl.arq.functions.CheckRegexSyntaxFunction;
import org.topbraid.shacl.arq.functions.EvalExprPFunction;
import org.topbraid.shacl.arq.functions.HasShapeFunction;
import org.topbraid.shacl.arq.functions.IsInTargetOfFunction;
import org.topbraid.shacl.arq.functions.IsValidForDatatypeFunction;
import org.topbraid.shacl.arq.functions.TargetContainsPFunction;
import org.topbraid.shacl.model.SHConstraintComponent;
import org.topbraid.shacl.model.SHJSConstraint;
import org.topbraid.shacl.model.SHJSExecutable;
import org.topbraid.shacl.model.SHJSFunction;
import org.topbraid.shacl.model.SHNodeShape;
import org.topbraid.shacl.model.SHParameter;
import org.topbraid.shacl.model.SHParameterizable;
import org.topbraid.shacl.model.SHParameterizableInstance;
import org.topbraid.shacl.model.SHParameterizableTarget;
import org.topbraid.shacl.model.SHPropertyShape;
import org.topbraid.shacl.model.SHResult;
import org.topbraid.shacl.model.SHRule;
import org.topbraid.shacl.model.SHSPARQLConstraint;
import org.topbraid.shacl.model.SHSPARQLFunction;
import org.topbraid.shacl.model.SHSPARQLTarget;
import org.topbraid.shacl.model.SHShape;
import org.topbraid.shacl.model.impl.SHConstraintComponentImpl;
import org.topbraid.shacl.model.impl.SHJSConstraintImpl;
import org.topbraid.shacl.model.impl.SHJSExecutableImpl;
import org.topbraid.shacl.model.impl.SHJSFunctionImpl;
import org.topbraid.shacl.model.impl.SHNodeShapeImpl;
import org.topbraid.shacl.model.impl.SHParameterImpl;
import org.topbraid.shacl.model.impl.SHParameterizableImpl;
import org.topbraid.shacl.model.impl.SHParameterizableInstanceImpl;
import org.topbraid.shacl.model.impl.SHParameterizableTargetImpl;
import org.topbraid.shacl.model.impl.SHPropertyShapeImpl;
import org.topbraid.shacl.model.impl.SHResultImpl;
import org.topbraid.shacl.model.impl.SHRuleImpl;
import org.topbraid.shacl.model.impl.SHSPARQLConstraintImpl;
import org.topbraid.shacl.model.impl.SHSPARQLFunctionImpl;
import org.topbraid.shacl.model.impl.SHSPARQLTargetImpl;
import org.topbraid.shacl.util.SHACLUtil;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.shacl.vocabulary.TOSH;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.util.SimpleImplementation;

public class SHFactory {
    private static void init(Personality<RDFNode> p) {
        p.add(SHConstraintComponent.class, new SimpleImplementation(SH.ConstraintComponent.asNode(), SHConstraintComponentImpl.class));
        p.add(SHJSConstraint.class, new SimpleImplementation(SH.JSConstraint.asNode(), SHJSConstraintImpl.class));
        p.add(SHJSExecutable.class, new SimpleImplementation(SH.JSExecutable.asNode(), SHJSExecutableImpl.class));
        p.add(SHJSFunction.class, new SimpleImplementation(SH.JSFunction.asNode(), SHJSFunctionImpl.class));
        p.add(SHParameter.class, new SimpleImplementation(SH.Parameter.asNode(), SHParameterImpl.class));
        p.add(SHParameterizable.class, new SimpleImplementation(SH.Parameterizable.asNode(), SHParameterizableImpl.class));
        p.add(SHParameterizableInstance.class, new SimpleImplementation(RDFS.Resource.asNode(), SHParameterizableInstanceImpl.class));
        p.add(SHParameterizableTarget.class, new SimpleImplementation(SH.Target.asNode(), SHParameterizableTargetImpl.class));
        p.add(SHPropertyShape.class, new SimpleImplementation(SH.PropertyShape.asNode(), SHPropertyShapeImpl.class));
        p.add(SHResult.class, new SimpleImplementation(SH.AbstractResult.asNode(), SHResultImpl.class));
        p.add(SHRule.class, new SimpleImplementation(SH.Rule.asNode(), SHRuleImpl.class));
        p.add(SHNodeShape.class, new SimpleImplementation(SH.NodeShape.asNode(), SHNodeShapeImpl.class));
        p.add(SHSPARQLConstraint.class, new SimpleImplementation(SH.SPARQLConstraint.asNode(), SHSPARQLConstraintImpl.class));
        p.add(SHSPARQLFunction.class, new SimpleImplementation(SH.SPARQLFunction.asNode(), SHSPARQLFunctionImpl.class));
        p.add(SHSPARQLTarget.class, new SimpleImplementation(SH.SPARQLTarget.asNode(), SHSPARQLTargetImpl.class));
        FunctionRegistry.get().put(TOSH.hasShape.getURI(), HasShapeFunction.class);
        FunctionRegistry.get().put(TOSH.isInTargetOf.getURI(), IsInTargetOfFunction.class);
        FunctionRegistry.get().put("http://spinrdf.org/spif#checkRegexSyntax", CheckRegexSyntaxFunction.class);
        FunctionRegistry.get().put("http://spinrdf.org/spif#isValidForDatatype", IsValidForDatatypeFunction.class);
        PropertyFunctionRegistry.get().put(TOSH.evalExpr.getURI(), EvalExprPFunction.class);
        PropertyFunctionRegistry.get().put(TOSH.targetContains.getURI(), TargetContainsPFunction.class);
    }

    public static SHConstraintComponent asConstraintComponent(RDFNode resource) {
        return resource.as(SHConstraintComponent.class);
    }

    public static SHSPARQLFunction asSPARQLFunction(RDFNode resource) {
        return resource.as(SHSPARQLFunction.class);
    }

    public static SHParameter asParameter(RDFNode resource) {
        return resource.as(SHParameter.class);
    }

    public static SHParameterizable asParameterizable(RDFNode resource) {
        return resource.as(SHParameterizable.class);
    }

    public static SHPropertyShape asPropertyShape(RDFNode node) {
        return node.as(SHPropertyShape.class);
    }

    public static SHNodeShape asNodeShape(RDFNode node) {
        return node.as(SHNodeShape.class);
    }

    public static SHSPARQLConstraint asSPARQLConstraint(RDFNode node) {
        return node.as(SHSPARQLConstraint.class);
    }

    public static SHSPARQLTarget asSPARQLTarget(RDFNode node) {
        return node.as(SHSPARQLTarget.class);
    }

    public static SHParameterizableInstance asTemplateCall(RDFNode resource) {
        return resource.as(SHParameterizableInstance.class);
    }

    public static SHShape asShape(RDFNode node) {
        if (node instanceof Resource && SHFactory.isPropertyShape((Resource)node)) {
            return SHFactory.asPropertyShape(node);
        }
        if (node instanceof Resource && SHFactory.isParameter((Resource)node)) {
            return SHFactory.asParameter(node);
        }
        return SHFactory.asNodeShape(node);
    }

    public static SHParameterizableTarget asParameterizableTarget(RDFNode node) {
        return node.as(SHParameterizableTarget.class);
    }

    public static boolean isJSTarget(RDFNode node) {
        return node instanceof Resource && JenaUtil.hasIndirectType((Resource)node, SH.JSTarget);
    }

    public static boolean isSPARQLConstraint(RDFNode node) {
        return node instanceof Resource && (JenaUtil.hasIndirectType((Resource)node, SH.SPARQLConstraint) || !((Resource)node).hasProperty(RDF.type) && node.getModel().contains(null, SH.sparql, node));
    }

    public static boolean isSPARQLTarget(RDFNode node) {
        return node instanceof Resource && JenaUtil.hasIndirectType((Resource)node, SH.SPARQLTarget);
    }

    public static boolean isNodeShape(RDFNode node) {
        if (node instanceof Resource) {
            if (JenaUtil.hasIndirectType((Resource)node, SH.NodeShape)) {
                return true;
            }
            if (node.isAnon() && !((Resource)node).hasProperty(RDF.type) && node.getModel().contains(null, SH.node, node)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isParameterizableConstraint(RDFNode node) {
        if (node instanceof Resource) {
            Resource r = (Resource)node;
            if (!r.hasProperty(RDF.type)) {
                return node.getModel().contains(null, SH.property, node) || node.getModel().contains(null, SH.parameter, node);
            }
            if (r.hasProperty(RDF.type, SH.NodeShape) || r.hasProperty(RDF.type, SH.PropertyShape) || r.hasProperty(RDF.type, SH.Parameter)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isParameter(Resource resource) {
        return resource.hasProperty(RDF.type, SH.Parameter) || !resource.hasProperty(RDF.type) && resource.getModel().contains(null, SH.parameter, resource);
    }

    public static boolean isParameterizableInstance(RDFNode node) {
        if (node instanceof Resource) {
            Resource dt;
            Resource resource = (Resource)node;
            for (Resource type : JenaUtil.getTypes(resource)) {
                if (!JenaUtil.hasIndirectType(type, SH.Parameterizable)) continue;
                return true;
            }
            if (!resource.hasProperty(RDF.type) && (dt = SHACLUtil.getResourceDefaultType(resource)) != null && JenaUtil.hasIndirectType(dt, SH.Parameterizable)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isPropertyShape(Resource resource) {
        return resource.hasProperty(RDF.type, SH.PropertyShape) || resource.getModel().contains(null, SH.property, resource);
    }

    static {
        SHFactory.init(BuiltinPersonalities.model);
    }
}

